% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot3d.r
\docType{methods}
\name{plot3d,ProfileSet-method}
\alias{plot3d,ProfileSet-method}
\alias{plot3d}
\alias{plot3d,Profile-method}
\title{3D Scatterplot of Geoelectrics Profiles}
\usage{
\S4method{plot3d}{ProfileSet}(x, title = x@title, sub = "",
  xlab = "", ylab = "", zlab = "", minData = x@minData,
  maxData = x@maxData, col = colors, trafo = log,
  psize = pointsize, ...)

\S4method{plot3d}{Profile}(x, title = "", sub = "", xlab = "",
  ylab = "", zlab = "", minData = x@processedData@minData,
  maxData = x@processedData@maxData, col = colors, trafo = log,
  psize = pointsize, ...)
}
\arguments{
\item{x}{either an object of a single Profile or a ProfileSet.}

\item{title}{title to be plotted.}

\item{sub}{subtitle to be plotted.}

\item{xlab}{label of the x-axes, e.g. length [m].}

\item{ylab}{label of the y-axes, e.g. height above sea level [m].}

\item{zlab}{label of the z-axes, e.g. length [m].}

\item{minData}{mimimum value to adjust color bar.}

\item{maxData}{maximum value to adjust color bar.}

\item{col}{vector of colors.}

\item{trafo}{transformation to be done on data (default: log).}

\item{psize}{size of value points (default: 10).}

\item{...}{parameters passed to points3d method of rgl package}
}
\description{
Plots the interpolated resistance values of the
processed data for a single profile or a set of profiles.
}
\examples{
data(sinkhole)

plot3d(sinkhole@profiles[[1]])
plot3d(sinkhole)
}
\seealso{
\code{\link{Profile-class}}, \code{\link{ProfileSet-class}},
\code{\link{plot}}, \code{\link{levelplot}}
}
