% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid_docs.R
\docType{data}
\name{grids}
\alias{grids}
\alias{us_state_grid1}
\alias{us_state_grid2}
\alias{eu_grid1}
\alias{aus_grid1}
\alias{sa_prov_grid1}
\alias{gb_london_boroughs_grid}
\alias{nhs_scot_grid}
\alias{india_grid1}
\alias{india_grid2}
\alias{argentina_grid1}
\alias{br_states_grid1}
\alias{sea_grid1}
\alias{mys_grid1}
\alias{fr_regions_grid1}
\alias{de_states_grid1}
\alias{us_or_counties_grid1}
\alias{us_wa_counties_grid1}
\alias{us_in_counties_grid1}
\alias{us_in_central_counties_grid1}
\alias{se_counties_grid1}
\alias{sf_bay_area_counties_grid1}
\alias{ua_region_grid1}
\alias{mx_state_grid1}
\alias{mx_state_grid2}
\alias{scotland_local_authority_grid1}
\alias{us_state_without_DC_grid1}
\alias{italy_grid1}
\alias{italy_grid2}
\alias{be_province_grid1}
\alias{us_state_grid3}
\alias{jp_prefs_grid1}
\alias{ng_state_grid1}
\alias{bd_upazila_grid1}
\alias{spain_prov_grid1}
\alias{ch_cantons_grid1}
\alias{ch_cantons_grid2}
\alias{china_prov_grid1}
\alias{world_86countries_grid}
\alias{se_counties_grid2}
\alias{uk_regions1}
\alias{us_state_contiguous_grid1}
\alias{sk_province_grid1}
\alias{ch_aargau_districts_grid1}
\alias{jo_gov_grid1}
\alias{es_autonomous_communities_grid1}
\alias{spain_prov_grid2}
\alias{world_countries_grid1}
\alias{br_states_grid2}
\alias{china_city_grid1}
\alias{kr_seoul_district_grid1}
\alias{nz_regions_grid1}
\alias{sl_regions_grid1}
\alias{us_census_div_grid1}
\alias{ar_tucuman_province_grid1}
\alias{us_nh_counties_grid1}
\alias{china_prov_grid2}
\alias{pl_voivodeships_grid1}
\alias{us_ia_counties_grid1}
\alias{us_id_counties_grid1}
\alias{ar_cordoba_dep_grid1}
\alias{us_fl_counties_grid1}
\alias{ar_buenosaires_communes_grid1}
\alias{nz_regions_grid2}
\alias{oecd_grid1}
\alias{ec_prov_grid1}
\alias{nl_prov_grid1}
\alias{ca_prov_grid1}
\alias{us_nc_counties_grid1}
\alias{mx_ciudad_prov_grid1}
\alias{bg_prov_grid1}
\alias{us_hhs_regions_grid1}
\alias{tw_counties_grid1}
\alias{tw_counties_grid2}
\alias{af_prov_grid1}
\alias{us_mi_counties_grid1}
\alias{pe_prov_grid1}
\alias{sa_prov_grid2}
\alias{mx_state_grid3}
\alias{cn_bj_districts_grid1}
\alias{us_va_counties_grid1}
\alias{us_mo_counties_grid1}
\alias{cl_santiago_prov_grid1}
\alias{us_tx_capcog_counties_grid1}
\alias{sg_planning_area_grid1}
\alias{in_state_ut_grid1}
\alias{cn_fujian_prov_grid1}
\alias{ca_quebec_electoral_districts_grid1}
\alias{nl_prov_grid2}
\alias{cn_bj_districts_grid2}
\alias{ar_santiago_del_estero_prov_grid1}
\alias{ar_formosa_prov_grid1}
\alias{ar_chaco_prov_grid1}
\alias{ar_catamarca_prov_grid1}
\alias{ar_jujuy_prov_grid1}
\alias{ar_neuquen_prov_grid1}
\alias{ar_san_luis_prov_grid1}
\alias{ar_san_juan_prov_grid1}
\alias{ar_santa_fe_prov_grid1}
\alias{ar_la_rioja_prov_grid1}
\alias{ar_mendoza_prov_grid1}
\alias{ar_salta_prov_grid1}
\alias{ar_rio_negro_prov_grid1}
\alias{uy_departamentos_grid1}
\alias{ar_buenos_aires_prov_electoral_dist_grid1}
\alias{europe_countries_grid1}
\alias{argentina_grid2}
\alias{us_state_without_DC_grid2}
\alias{jp_prefs_grid2}
\alias{na_regions_grid1}
\alias{mm_state_grid1}
\alias{us_state_with_DC_PR_grid1}
\alias{fr_departements_grid1}
\alias{ar_salta_prov_grid2}
\alias{ie_counties_grid1}
\alias{sg_regions_grid1}
\alias{us_ny_counties_grid1}
\alias{ru_federal_subjects_grid1}
\alias{us_ca_counties_grid1}
\alias{lk_districts_grid1}
\alias{us_state_without_DC_grid3}
\alias{co_cali_subdivisions_grid1}
\alias{us_in_northern_counties_grid1}
\alias{italy_grid3}
\alias{us_state_with_DC_PR_grid2}
\alias{us_state_grid7}
\alias{sg_planning_area_grid2}
\alias{ch_cantons_fl_grid1}
\alias{europe_countries_grid2}
\alias{us_states_territories_grid1}
\alias{us_tn_counties_grid1}
\alias{us_il_chicago_community_areas_grid1}
\alias{us_state_with_DC_PR_grid3}
\alias{in_state_ut_grid2}
\alias{at_states_grid1}
\alias{us_pa_counties_grid1}
\alias{us_oh_counties_grid1}
\alias{fr_departements_grid2}
\alias{us_wi_counties_grid1}
\alias{africa_countries_grid1}
\alias{no_counties_grid1}
\alias{tr_provinces_grid1}
\alias{us_eastern_states_grid1}
\alias{br_states_grid3}
\alias{us_states_territories_grid2}
\alias{us_state_grid8}
\alias{us_state_grid9}
\alias{fr_departements_grid3}
\alias{in_state_ut_grid3}
\alias{th_provinces_grid1}
\alias{th_bangkok_districts_grid1}
\alias{ca_us_prov_state_grid1}
\alias{sy_governorates_grid1}
\alias{ro_counties_grid1}
\alias{us_va_health_districts_grid1}
\alias{us_state_without_DC_canada_prov_grid1}
\alias{ir_provinces_grid1}
\alias{co_departments_grid1}
\alias{ir_tehran_districts_grid1}
\alias{ro_counties_grid2}
\alias{gb_sct_council_areas_grid1}
\alias{mw_districts_grid1}
\alias{dk_cph_grid1}
\alias{us_nv_counties_grid1}
\alias{ie_counties_grid2}
\alias{bo_departments_grid1}
\alias{ie_counties_grid3}
\alias{co_departments_grid2}
\alias{americas_countries_grid1}
\alias{us_census_div_grid2}
\alias{ar_buenosaires_conurbano_grid1}
\alias{us_md_counties_grid1}
\alias{us_ia_counties_grid2}
\alias{us_western_states_grid1}
\alias{us_ga_counties_grid1}
\alias{ro_counties_grid3}
\alias{es_autonomous_communities_grid2}
\alias{qa_municipalities_grid1}
\alias{kz_region_grid1}
\alias{middle_east_grid1}
\alias{cz_prague_districts_grid1}
\alias{es_catalonia_comarques_grid1}
\alias{no_counties_grid2}
\alias{fi_helsinki_neighborhoods_grid1}
\alias{us_state_without_DC_AK_HI_grid1}
\alias{ru_federal_subjects_grid2}
\alias{us_ut_counties_grid1}
\alias{in_state_ut_grid4}
\alias{ec_prov_grid2}
\alias{es_prov_grid1}
\alias{americas_countries_grid2}
\alias{us_nm_counties_grid1}
\alias{us_me_counties_grid1}
\alias{cu_prov_grid1}
\alias{ge_regions_grid1}
\alias{co_departments_grid3}
\alias{gb_london_boroughs_grid2}
\alias{gb_sct_aberdeenshire_IZ_grid1}
\alias{gb_sct_aberdeenshire_wards_grid1}
\alias{at_vienna_districts_grid1}
\alias{gh_regions_grid1}
\alias{uy_departamentos_grid2}
\alias{ch_vaud_districts_grid1}
\alias{us_ca_counties_FIPS_grid1}
\alias{kr_seoul_district_grid2}
\alias{kr_districts_grid1}
\alias{oecd_grid2}
\alias{bo_departments_grid2}
\alias{ca_us_prov_state_grid2}
\alias{us_il_counties_grid1}
\alias{tn_governorates_grid1}
\alias{gb_sct_glasgow_wards_grid1}
\alias{kr_provinces_grid1}
\alias{kr_counties_districts_cities_grid1}
\alias{us_ok_counties_grid1}
\alias{us_dc_neighborhoods_grid1}
\alias{us_mn_counties_grid1}
\title{Geo Grids}
\usage{
us_state_grid1

us_state_grid2

eu_grid1

aus_grid1

sa_prov_grid1

gb_london_boroughs_grid

nhs_scot_grid

india_grid1

india_grid2

argentina_grid1

br_states_grid1

sea_grid1

mys_grid1

fr_regions_grid1

de_states_grid1

us_or_counties_grid1

us_wa_counties_grid1

us_in_counties_grid1

us_in_central_counties_grid1

se_counties_grid1

sf_bay_area_counties_grid1

ua_region_grid1

mx_state_grid1

mx_state_grid2

scotland_local_authority_grid1

us_state_without_DC_grid1

italy_grid1

italy_grid2

be_province_grid1

us_state_grid3

jp_prefs_grid1

ng_state_grid1

bd_upazila_grid1

spain_prov_grid1

ch_cantons_grid1

ch_cantons_grid2

china_prov_grid1

world_86countries_grid

se_counties_grid2

uk_regions1

us_state_contiguous_grid1

sk_province_grid1

ch_aargau_districts_grid1

jo_gov_grid1

es_autonomous_communities_grid1

spain_prov_grid2

world_countries_grid1

br_states_grid2

china_city_grid1

kr_seoul_district_grid1

nz_regions_grid1

sl_regions_grid1

us_census_div_grid1

ar_tucuman_province_grid1

us_nh_counties_grid1

china_prov_grid2

pl_voivodeships_grid1

us_ia_counties_grid1

us_id_counties_grid1

ar_cordoba_dep_grid1

us_fl_counties_grid1

ar_buenosaires_communes_grid1

nz_regions_grid2

oecd_grid1

ec_prov_grid1

nl_prov_grid1

ca_prov_grid1

us_nc_counties_grid1

mx_ciudad_prov_grid1

bg_prov_grid1

us_hhs_regions_grid1

tw_counties_grid1

tw_counties_grid2

af_prov_grid1

us_mi_counties_grid1

pe_prov_grid1

sa_prov_grid2

mx_state_grid3

cn_bj_districts_grid1

us_va_counties_grid1

us_mo_counties_grid1

cl_santiago_prov_grid1

us_tx_capcog_counties_grid1

sg_planning_area_grid1

in_state_ut_grid1

cn_fujian_prov_grid1

ca_quebec_electoral_districts_grid1

nl_prov_grid2

cn_bj_districts_grid2

ar_santiago_del_estero_prov_grid1

ar_formosa_prov_grid1

ar_chaco_prov_grid1

ar_catamarca_prov_grid1

ar_jujuy_prov_grid1

ar_neuquen_prov_grid1

ar_san_luis_prov_grid1

ar_san_juan_prov_grid1

ar_santa_fe_prov_grid1

ar_la_rioja_prov_grid1

ar_mendoza_prov_grid1

ar_salta_prov_grid1

ar_rio_negro_prov_grid1

uy_departamentos_grid1

ar_buenos_aires_prov_electoral_dist_grid1

europe_countries_grid1

argentina_grid2

us_state_without_DC_grid2

jp_prefs_grid2

na_regions_grid1

mm_state_grid1

us_state_with_DC_PR_grid1

fr_departements_grid1

ar_salta_prov_grid2

ie_counties_grid1

sg_regions_grid1

us_ny_counties_grid1

ru_federal_subjects_grid1

us_ca_counties_grid1

lk_districts_grid1

us_state_without_DC_grid3

co_cali_subdivisions_grid1

us_in_northern_counties_grid1

italy_grid3

us_state_with_DC_PR_grid2

us_state_grid7

sg_planning_area_grid2

ch_cantons_fl_grid1

europe_countries_grid2

us_states_territories_grid1

us_tn_counties_grid1

us_il_chicago_community_areas_grid1

us_state_with_DC_PR_grid3

in_state_ut_grid2

at_states_grid1

us_pa_counties_grid1

us_oh_counties_grid1

fr_departements_grid2

us_wi_counties_grid1

africa_countries_grid1

no_counties_grid1

tr_provinces_grid1

us_eastern_states_grid1

br_states_grid3

us_states_territories_grid2

us_state_grid8

us_state_grid9

fr_departements_grid3

in_state_ut_grid3

th_provinces_grid1

th_bangkok_districts_grid1

ca_us_prov_state_grid1

sy_governorates_grid1

ro_counties_grid1

us_va_health_districts_grid1

us_state_without_DC_canada_prov_grid1

ir_provinces_grid1

co_departments_grid1

ir_tehran_districts_grid1

ro_counties_grid2

gb_sct_council_areas_grid1

mw_districts_grid1

dk_cph_grid1

us_nv_counties_grid1

ie_counties_grid2

bo_departments_grid1

ie_counties_grid3

co_departments_grid2

americas_countries_grid1

us_census_div_grid2

ar_buenosaires_conurbano_grid1

us_md_counties_grid1

us_ia_counties_grid2

us_western_states_grid1

us_ga_counties_grid1

ro_counties_grid3

es_autonomous_communities_grid2

qa_municipalities_grid1

kz_region_grid1

middle_east_grid1

cz_prague_districts_grid1

es_catalonia_comarques_grid1

no_counties_grid2

fi_helsinki_neighborhoods_grid1

us_state_without_DC_AK_HI_grid1

ru_federal_subjects_grid2

us_ut_counties_grid1

in_state_ut_grid4

ec_prov_grid2

es_prov_grid1

americas_countries_grid2

us_nm_counties_grid1

us_me_counties_grid1

cu_prov_grid1

ge_regions_grid1

co_departments_grid3

gb_london_boroughs_grid2

gb_sct_aberdeenshire_IZ_grid1

gb_sct_aberdeenshire_wards_grid1

at_vienna_districts_grid1

gh_regions_grid1

uy_departamentos_grid2

ch_vaud_districts_grid1

us_ca_counties_FIPS_grid1

kr_seoul_district_grid2

kr_districts_grid1

oecd_grid2

bo_departments_grid2

ca_us_prov_state_grid2

us_il_counties_grid1

tn_governorates_grid1

gb_sct_glasgow_wards_grid1

kr_provinces_grid1

kr_counties_districts_cities_grid1

us_ok_counties_grid1

us_dc_neighborhoods_grid1

us_mn_counties_grid1
}
\description{
There are now 216 grids available in this package and more online. To view a full list of available grids, see \href{https://raw.githubusercontent.com/hafen/grid-designer/master/grid_list.json}{here}. To create and submit your own grid, see \href{https://hafen.github.io/grid-designer/}{here}. To see several examples of grids being used to visualize data, see \code{\link{facet_geo}}.

\itemize{
\item \strong{us_state_grid1:} Grid layout for US states (including DC).
}

\itemize{
\item \strong{us_state_grid2:} Grid layout for US states (including DC).
}

\itemize{
\item \strong{eu_grid1:} Grid layout for the 28 EU Countries.
}

\itemize{
\item \strong{aus_grid1:} Grid layout for the Australian States and Territories.. Thanks to jonocarroll.
}

\itemize{
\item \strong{sa_prov_grid1:} Grid layout for the provinces of South Africa. Thanks to jonmcalder.
}

\itemize{
\item \strong{gb_london_boroughs_grid:} Grid layout for the boroughs of London. Note that the column \code{code_ons} contains the codes used by UK Office for National Statistics.. Thanks to eldenvo.
}

\itemize{
\item \strong{nhs_scot_grid:} Grid layout for a grid of NHS Scotland Health Boards. Note that the column \code{code} contains the codes used by UK Office for National Statistics.. Thanks to jsphdms.
}

\itemize{
\item \strong{india_grid1:} Grid layout for India states (not including union territories).. Thanks to meysubb.
}

\itemize{
\item \strong{india_grid2:} Grid layout for India states (not including union territories)..
}

\itemize{
\item \strong{argentina_grid1:} Grid for the 23 provinces of Argentina. It includes the Malvinas/Falkland Islands and the Antarctic Territories (these are disputed, but they are included since many researchers might use data from these locations).. Thanks to eliocamp.
}

\itemize{
\item \strong{br_states_grid1:} Grid for the 27 states of Brazil.. Thanks to italocegatta.
}

\itemize{
\item \strong{sea_grid1:} Grid for South East Asian countries.. Thanks to jasonjb82.
}

\itemize{
\item \strong{mys_grid1:} Grid for Malaysian states and territories.. Thanks to jasonjb82.
}

\itemize{
\item \strong{fr_regions_grid1:} Land and overseas regions of France. Codes are INSEE codes.. Thanks to mtmx.
}

\itemize{
\item \strong{de_states_grid1:} Grid for the German states ('Länder'). Thanks to DominikVogel.
}

\itemize{
\item \strong{us_or_counties_grid1:} Grid for Oregon counties.. Thanks to aosmith16.
}

\itemize{
\item \strong{us_wa_counties_grid1:} Grid for Washington counties..
}

\itemize{
\item \strong{us_in_counties_grid1:} Grid for Indiana counties.. Thanks to nateapathy.
}

\itemize{
\item \strong{us_in_central_counties_grid1:} Grid for central Indiana counties.. Thanks to nateapathy.
}

\itemize{
\item \strong{se_counties_grid1:} Grid for counties of Sweden.. Thanks to duleise.
}

\itemize{
\item \strong{sf_bay_area_counties_grid1:} Grid of the 9 San Francisco Bay Area counties.. Thanks to Eunoia.
}

\itemize{
\item \strong{ua_region_grid1:} Grid of administrative divisions of Ukraine (24 oblasts, one autonomous region, and two cities).. Thanks to woldemarg.
}

\itemize{
\item \strong{mx_state_grid1:} Grid layout for the states of Mexico.. Thanks to ikashnitsky.
}

\itemize{
\item \strong{mx_state_grid2:} Grid layout for the states of Mexico.. Thanks to diegovalle.
}

\itemize{
\item \strong{scotland_local_authority_grid1:} Grid layout for the local authorities of Scotland.. Thanks to davidhen.
}

\itemize{
\item \strong{us_state_without_DC_grid1:} Grid layout for US states (excluding DC). Thanks to ejr248.
}

\itemize{
\item \strong{italy_grid1:} Grid layout for regions of Italy (in collaboration with Stella Cangelosi and Luciana Dalla Valle).. Thanks to JulianStander.
}

\itemize{
\item \strong{italy_grid2:} Grid layout for regions of Italy (in collaboration with Stella Cangelosi and Luciana Dalla Valle).. Thanks to JulianStander.
}

\itemize{
\item \strong{be_province_grid1:} Grid layout for provinces of Belgium plus Brussels, including names in three languages (French, Dutch, English) and Belgium internal codes (NIS).. Thanks to ericlecoutre.
}

\itemize{
\item \strong{us_state_grid3:} Grid layout for US states (including DC).. Thanks to kanishkamisra.
}

\itemize{
\item \strong{jp_prefs_grid1:} Grid layout for the prefectures of Japan.. Thanks to uribo.
}

\itemize{
\item \strong{ng_state_grid1:} Grid layout for the 37 Federal States of Nigeria.. Thanks to aledemogr.
}

\itemize{
\item \strong{bd_upazila_grid1:} Grid layout for Bangladesh 64 Upazilas.. Thanks to aledemogr.
}

\itemize{
\item \strong{spain_prov_grid1:} Grid layout for Provinces of Spain.. Thanks to kintero.
}

\itemize{
\item \strong{ch_cantons_grid1:} Grid layout for Cantons of Switzerland.. Thanks to tinu-schneider.
}

\itemize{
\item \strong{ch_cantons_grid2:} Grid layout for Cantons of Switzerland.. Thanks to rastrau.
}

\itemize{
\item \strong{china_prov_grid1:} Grid layout for Provinces of China.. Thanks to weiyunna.
}

\itemize{
\item \strong{world_86countries_grid:} Grid layout for 86 countries in the world.. Thanks to akangsha.
}

\itemize{
\item \strong{se_counties_grid2:} Grid for counties of Sweden.. Thanks to richardohrvall.
}

\itemize{
\item \strong{uk_regions1:} Grid for regions of the UK (aka EU standard NUTS 1 areas).. Thanks to paulb20.
}

\itemize{
\item \strong{us_state_contiguous_grid1:} Grid layout for the contiguous US states (including DC).. Thanks to andrewsr.
}

\itemize{
\item \strong{sk_province_grid1:} Grid layout for South Korean sis and dos (metropolitan/special/autonomous cities and provinces).. Thanks to heon131.
}

\itemize{
\item \strong{ch_aargau_districts_grid1:} Grid layout for Districts of the Canton of Aargau, Switzerland.. Thanks to zumbov2.
}

\itemize{
\item \strong{jo_gov_grid1:} Grid layout for Governorates of Jordan.. Thanks to aledemogr.
}

\itemize{
\item \strong{es_autonomous_communities_grid1:} Grid layout for Spanish 'Comunidades Autónomas'.. Thanks to JoseAntonioOrtega.
}

\itemize{
\item \strong{spain_prov_grid2:} Grid layout for Provinces of Spain.. Thanks to JoseAntonioOrtega.
}

\itemize{
\item \strong{world_countries_grid1:} Grid layout for countries of the world, with a few exclusions. See .. Thanks to JoseAntonioOrtega.
}

\itemize{
\item \strong{br_states_grid2:} Grid for the 27 states of Brazil.. Thanks to hafen.
}

\itemize{
\item \strong{china_city_grid1:} Grid layout of cities in China.. Thanks to CharleneDeng1.
}

\itemize{
\item \strong{kr_seoul_district_grid1:} Grid layout of Seoul's 25 districts.. Thanks to yonghah.
}

\itemize{
\item \strong{nz_regions_grid1:} Grid layout for regions of New Zealand.. Thanks to pierreroudier.
}

\itemize{
\item \strong{sl_regions_grid1:} Grid layout of Slovenian regions.. Thanks to SR1986.
}

\itemize{
\item \strong{us_census_div_grid1:} Grid layout of US Census divisions.. Thanks to mkiang.
}

\itemize{
\item \strong{ar_tucuman_province_grid1:} Grid layout for Argentina Tucumán Province political divisions (departments). Thanks to TuQmano.
}

\itemize{
\item \strong{us_nh_counties_grid1:} Grid layout for the 10 counties in New Hampshire.. Thanks to ghost.
}

\itemize{
\item \strong{china_prov_grid2:} Grid layout for Provinces of China.. Thanks to jw2531.
}

\itemize{
\item \strong{pl_voivodeships_grid1:} Grid layout for Polish voivodeships (provinces). Thanks to erzk.
}

\itemize{
\item \strong{us_ia_counties_grid1:} Grid layout for counties in Iowa. Thanks to jrennyb.
}

\itemize{
\item \strong{us_id_counties_grid1:} Grid layout for counties in Idaho. Thanks to hathawayj.
}

\itemize{
\item \strong{ar_cordoba_dep_grid1:} Grid layout for departments of Cordoba province in Argentina.. Thanks to TuQmano.
}

\itemize{
\item \strong{us_fl_counties_grid1:} Grid for Florida counties.. Thanks to ejr248.
}

\itemize{
\item \strong{ar_buenosaires_communes_grid1:} Grid for communes of Buenos Aires, Argentina.. Thanks to TuQmano.
}

\itemize{
\item \strong{nz_regions_grid2:} Grid layout for regions of New Zealand.. Thanks to pierreroudier.
}

\itemize{
\item \strong{oecd_grid1:} Grid layout for OECD member countries.. Thanks to arcruz0.
}

\itemize{
\item \strong{ec_prov_grid1:} Grid layout for provinces of Ecuador. Thanks to Ricardo95RM.
}

\itemize{
\item \strong{nl_prov_grid1:} Grid layout for provinces of Netherlands. Thanks to ruditurksema.
}

\itemize{
\item \strong{ca_prov_grid1:} Grid layout for provinces of Canada. Thanks to michael-chong.
}

\itemize{
\item \strong{us_nc_counties_grid1:} Grid layout for Counties of North Carolina, United States. Thanks to mtdukes.
}

\itemize{
\item \strong{mx_ciudad_prov_grid1:} Grid layout for Districts of Mexico City, Mexico. Thanks to Ivangea.
}

\itemize{
\item \strong{bg_prov_grid1:} Grid layout for provinces of Bulgaria. Thanks to savinastoitsova.
}

\itemize{
\item \strong{us_hhs_regions_grid1:} This grid approximates the U.S. Health and Human Services Region map. Thanks to akitepowell.
}

\itemize{
\item \strong{tw_counties_grid1:} Grid layout for Counties of Taiwan. Thanks to csh484912274.
}

\itemize{
\item \strong{tw_counties_grid2:} Grid layout for Counties of Taiwan including Lienchiang County. Thanks to csh484912274.
}

\itemize{
\item \strong{af_prov_grid1:} Grid layout for Provinces of Afghanistan. Thanks to jrennyb.
}

\itemize{
\item \strong{us_mi_counties_grid1:} Grid layout for Counties of Michigan, United States. Thanks to jrennyb.
}

\itemize{
\item \strong{pe_prov_grid1:} Grid layout for Provinces of Peru. Thanks to jmcastagnetto.
}

\itemize{
\item \strong{sa_prov_grid2:} Grid layout for Provinces of South Africa. Thanks to kamermanpr.
}

\itemize{
\item \strong{mx_state_grid3:} Grid layout for States of Mexico. Thanks to ikashnitsky.
}

\itemize{
\item \strong{cn_bj_districts_grid1:} Grids for Administrative Districts of Beijing, China. Thanks to shiedelweiss.
}

\itemize{
\item \strong{us_va_counties_grid1:} Grids for Counties of Virginia, United States. Thanks to joshyazman.
}

\itemize{
\item \strong{us_mo_counties_grid1:} Grids for Counties of Missouri, United States. Thanks to Yanqi-Xu.
}

\itemize{
\item \strong{cl_santiago_prov_grid1:} Communes of Santiago Province, Chile. Thanks to robsalasco.
}

\itemize{
\item \strong{us_tx_capcog_counties_grid1:} This is a grid of a 10 county planning region around Austin, Texas, United States. Thanks to mth444.
}

\itemize{
\item \strong{sg_planning_area_grid1:} Grids for Planning Areas of Singapore. Thanks to Elenafuyi.
}

\itemize{
\item \strong{in_state_ut_grid1:} Grid of Indian States and Union Territories. Thanks to seanangio.
}

\itemize{
\item \strong{cn_fujian_prov_grid1:} Grid of counties of Fujian Province, China. Thanks to nannanchen333.
}

\itemize{
\item \strong{ca_quebec_electoral_districts_grid1:} Grid of Electoral Districts of Québec, Canada. Thanks to jhroy.
}

\itemize{
\item \strong{nl_prov_grid2:} Grid with the provinces of The Netherlands with codes that are used by the statistical institute of NL. Thanks to edwindj.
}

\itemize{
\item \strong{cn_bj_districts_grid2:} Grid with districts of Beijing, China. Thanks to zouhx11.
}

\itemize{
\item \strong{ar_santiago_del_estero_prov_grid1:} Grid with districts of Santiago del Estero Province, Argentina. Thanks to TuQmano.
}

\itemize{
\item \strong{ar_formosa_prov_grid1:} Grid with districts of Formosa Province, Argentina. Thanks to TuQmano.
}

\itemize{
\item \strong{ar_chaco_prov_grid1:} Grid with districts of Chaco Province, Argentina. Thanks to TuQmano.
}

\itemize{
\item \strong{ar_catamarca_prov_grid1:} Grid with districts of Catamarca Province, Argentina. Thanks to TuQmano.
}

\itemize{
\item \strong{ar_jujuy_prov_grid1:} Grid with districts of Jujuy Province, Argentina. Thanks to TuQmano.
}

\itemize{
\item \strong{ar_neuquen_prov_grid1:} Grid with districts of Neuquen Province, Argentina. Thanks to TuQmano.
}

\itemize{
\item \strong{ar_san_luis_prov_grid1:} Grid with districts of San Luis Province, Argentina. Thanks to TuQmano.
}

\itemize{
\item \strong{ar_san_juan_prov_grid1:} Grid with districts of San Juan Province, Argentina. Thanks to TuQmano.
}

\itemize{
\item \strong{ar_santa_fe_prov_grid1:} Grid with districts of Santa Fe Province, Argentina. Thanks to TuQmano.
}

\itemize{
\item \strong{ar_la_rioja_prov_grid1:} Grid with districts of La Rioja Province, Argentina. Thanks to TuQmano.
}

\itemize{
\item \strong{ar_mendoza_prov_grid1:} Grid with districts of Mendoza Province, Argentina. Thanks to TuQmano.
}

\itemize{
\item \strong{ar_salta_prov_grid1:} Grid with districts of Salta Province, Argentina. Thanks to TuQmano.
}

\itemize{
\item \strong{ar_rio_negro_prov_grid1:} Grid with districts of Rio Negro Province, Argentina. Thanks to TuQmano.
}

\itemize{
\item \strong{uy_departamentos_grid1:} Grid with Departamentos of Uruguay. Thanks to TuQmano.
}

\itemize{
\item \strong{ar_buenos_aires_prov_electoral_dist_grid1:} Grid with Electoral Districts of Buenos Aires Province, Argentina. Thanks to TuQmano.
}

\itemize{
\item \strong{europe_countries_grid1:} Grid layout for all European countries except Vatican City, Monaco, San Marino and Liechtenstein. Thanks to THargreaves.
}

\itemize{
\item \strong{argentina_grid2:} Grid layout for Argentina without Islas Malvinas and Antártida Argentina. Thanks to TuQmano.
}

\itemize{
\item \strong{us_state_without_DC_grid2:} Grid layout for United States with AK and HI flush with CA. Thanks to christophercannon.
}

\itemize{
\item \strong{jp_prefs_grid2:} Grid layout for Prefectures of Japan. Thanks to Ryo-N7.
}

\itemize{
\item \strong{na_regions_grid1:} Regions of Namibia. Thanks to stedy.
}

\itemize{
\item \strong{mm_state_grid1:} States of Myanmar. Thanks to htinkyawaye.
}

\itemize{
\item \strong{us_state_with_DC_PR_grid1:} United States of America including Washington, D.C. and Puerto Rico. Thanks to krothkin.
}

\itemize{
\item \strong{fr_departements_grid1:} Grid for France's departements, the second levels of administrative boundaries after the regions. Thanks to tvroylandt.
}

\itemize{
\item \strong{ar_salta_prov_grid2:} Grids for Salta Province Argentina. Thanks to tartagalensis.
}

\itemize{
\item \strong{ie_counties_grid1:} Ireland counties. Code is the car number plate abbreviation for Republic counties, similar for the six counties of Northern Ireland. Tipperary is split North / South for historical reasons. Thanks to eugene100hickey.
}

\itemize{
\item \strong{sg_regions_grid1:} Urban planning regions of Singapore. Thanks to erhuttk.
}

\itemize{
\item \strong{us_ny_counties_grid1:} Counties of New York State, United States. Thanks to jjdfsny.
}

\itemize{
\item \strong{ru_federal_subjects_grid1:} Federal Subjects of Russia. Thanks to ParanoidAndroid18.
}

\itemize{
\item \strong{us_ca_counties_grid1:} Counties of the State of California, United States. Thanks to MartinLe5.
}

\itemize{
\item \strong{lk_districts_grid1:} Second level administrative divisions of Sri Lanka. Thanks to thiyangt.
}

\itemize{
\item \strong{us_state_without_DC_grid3:} United States grid without Washington, D.C. Thanks to ghost.
}

\itemize{
\item \strong{co_cali_subdivisions_grid1:} Corregimientos of Cali, Columbia. Thanks to Carolina101.
}

\itemize{
\item \strong{us_in_northern_counties_grid1:} Northern Counties of Indiana, United States. Thanks to robertoge.
}

\itemize{
\item \strong{italy_grid3:} Autonomous Provinces of Italy. Thanks to danilolofaro.
}

\itemize{
\item \strong{us_state_with_DC_PR_grid2:} Grid of 50 states, DC, and Puerto Rico. Thanks to krmaas.
}

\itemize{
\item \strong{us_state_grid7:} United States grid with Washington, D.C. Thanks to yichenqin.
}

\itemize{
\item \strong{sg_planning_area_grid2:} Singapore Planning Areas. Thanks to ZhimaoElliott.
}

\itemize{
\item \strong{ch_cantons_fl_grid1:} Grid layout for Cantons of Switzerland and the neighbouring Prinicipality of Liechtenstein. Thanks to rastrau.
}

\itemize{
\item \strong{europe_countries_grid2:} Grid layout for European countries (minus micro nations). Thanks to rastrau.
}

\itemize{
\item \strong{us_states_territories_grid1:} Grid layout for U.S. states and territories. Thanks to rastrau.
}

\itemize{
\item \strong{us_tn_counties_grid1:} Grid layout for counties of Tennesee, United States. Thanks to binkleym.
}

\itemize{
\item \strong{us_il_chicago_community_areas_grid1:} Grid layout for the Community Areas of Chicago. Thanks to leungkp.
}

\itemize{
\item \strong{us_state_with_DC_PR_grid3:} United States grid with Washington, D.C. and Puerto Rico. Thanks to klittle314.
}

\itemize{
\item \strong{in_state_ut_grid2:} Grid of Indian States and Union Territories. Thanks to dnyansagar.
}

\itemize{
\item \strong{at_states_grid1:} Grid layout for States of Austria. Thanks to wkapga.
}

\itemize{
\item \strong{us_pa_counties_grid1:} Grid layout of Counties of Pennsylvania, United States. Thanks to urbanSpatial.
}

\itemize{
\item \strong{us_oh_counties_grid1:} Grid layout of Counties of Ohio, United States. Thanks to taylorokonek.
}

\itemize{
\item \strong{fr_departements_grid2:} Grid layout of Departements of France. Thanks to jerbou.
}

\itemize{
\item \strong{us_wi_counties_grid1:} Grid layout for counties of Wisconsin, United States. Thanks to aravamu2.
}

\itemize{
\item \strong{africa_countries_grid1:} Grid for all countries in Africa. Namibia added as 'NAM' to avoid NA collisions. Thanks to ntncmch.
}

\itemize{
\item \strong{no_counties_grid1:} Grid of counties of Norway. Thanks to NanAmalie1.
}

\itemize{
\item \strong{tr_provinces_grid1:} Grid of Provinces of Turkey. Thanks to sadettindemirel.
}

\itemize{
\item \strong{us_eastern_states_grid1:} US State_grid showing only the states for which some portion falls east of the 100th meridian. Thanks to mihiarc.
}

\itemize{
\item \strong{br_states_grid3:} Grid map of States of Brazil organized horizontally by region. Thanks to lzrmr.
}

\itemize{
\item \strong{us_states_territories_grid2:} Grid map of US States and Territories. Thanks to edavidaja.
}

\itemize{
\item \strong{us_state_grid8:} Grid map of US States including Washington, D.C.. Thanks to krothkin.
}

\itemize{
\item \strong{us_state_grid9:} Grid map of US States including Washington, D.C.. Thanks to krothkin.
}

\itemize{
\item \strong{fr_departements_grid3:} Grid of Departements of France. Thanks to leachareyre.
}

\itemize{
\item \strong{in_state_ut_grid3:} Grid of Indian States and Union Territories. Thanks to aeschuma.
}

\itemize{
\item \strong{th_provinces_grid1:} Grid of Provinces of Thailand. Thanks to PaulApivat.
}

\itemize{
\item \strong{th_bangkok_districts_grid1:} Grid of Districts of Bangkok, Thailand. Thanks to PaulApivat.
}

\itemize{
\item \strong{ca_us_prov_state_grid1:} Grid of Provinces and States of Canada and US. Thanks to ahcyip.
}

\itemize{
\item \strong{sy_governorates_grid1:} Grid of ADM-1 units (governorates) for Syria. Thanks to jschon637.
}

\itemize{
\item \strong{ro_counties_grid1:} Grid of counties (județe) of Romania. Thanks to bogdanantonescu.
}

\itemize{
\item \strong{us_va_health_districts_grid1:} Grid of Commonwealth of Virginia's Health Districts. Thanks to osesusan.
}

\itemize{
\item \strong{us_state_without_DC_canada_prov_grid1:} US States without DC with 10 Canadian Provinces. Thanks to opus1993.
}

\itemize{
\item \strong{ir_provinces_grid1:} Provinces of Iran. Thanks to mcnakhaee.
}

\itemize{
\item \strong{co_departments_grid1:} Departments of Colombia. Thanks to mikafui2020.
}

\itemize{
\item \strong{ir_tehran_districts_grid1:} Grid for 22 districts in Tehran, Iran. Thanks to mcnakhaee.
}

\itemize{
\item \strong{ro_counties_grid2:} Grid of Romanian Counties. Thanks to alexfg.
}

\itemize{
\item \strong{gb_sct_council_areas_grid1:} Council Areas of Scotland. Thanks to AndrewAiton.
}

\itemize{
\item \strong{mw_districts_grid1:} Grid of 27 districts of Malawi (all districts other than Likoma, which is an island). Thanks to taylorokonek.
}

\itemize{
\item \strong{dk_cph_grid1:} Grid of the 10 districts of Copenhagen, Denmark. Thanks to Straubinger.
}

\itemize{
\item \strong{us_nv_counties_grid1:} Counties of State of Nevada, United States. Thanks to schmidtDETR.
}

\itemize{
\item \strong{ie_counties_grid2:} Counties of Ireland. Thanks to cbhurley.
}

\itemize{
\item \strong{bo_departments_grid1:} Grid of Departamental Political Division of Bolivia. Thanks to tartagalensis.
}

\itemize{
\item \strong{ie_counties_grid3:} Grid of 32 Counties of Ireland with Tipperary as one county. Thanks to superboreen.
}

\itemize{
\item \strong{co_departments_grid2:} Grid of Departments of Colombia with municipal DANE codes. Thanks to sfanchi.
}

\itemize{
\item \strong{americas_countries_grid1:} Map of countries of North and South America. Thanks to Aminsn.
}

\itemize{
\item \strong{us_census_div_grid2:} Geofacet grid for the cartographic boundary map of the four official US regions, according to the US Census Bureau. Thanks to AnneIoannides.
}

\itemize{
\item \strong{ar_buenosaires_conurbano_grid1:} Grids representing the greater Buenos Aires area which includes the autonomous city of Buenos Aires and some department/partidos of the Buenos Aires Province. Thanks to SantiagoEsteban.
}

\itemize{
\item \strong{us_md_counties_grid1:} Counties of the State of Maryland, United States. Thanks to tecason.
}

\itemize{
\item \strong{us_ia_counties_grid2:} Counties of the State of Iowa, United States. Thanks to tecason.
}

\itemize{
\item \strong{us_western_states_grid1:} Grid of Western United States. Thanks to JHasselbeck.
}

\itemize{
\item \strong{us_ga_counties_grid1:} Grid of Counties of Georgia, United States. Thanks to pjm407.
}

\itemize{
\item \strong{ro_counties_grid3:} Counties (Judete) of Romania. Thanks to vparvu.
}

\itemize{
\item \strong{es_autonomous_communities_grid2:} Autonomous Communities of Spain. Thanks to dieghernan.
}

\itemize{
\item \strong{qa_municipalities_grid1:} Municipalities of Qatar. Thanks to stedy.
}

\itemize{
\item \strong{kz_region_grid1:} Regions of Kazakhstan. Thanks to Sofiya2809.
}

\itemize{
\item \strong{middle_east_grid1:} Countries of the Middle East with ISO codes. Thanks to anamartincalde.
}

\itemize{
\item \strong{cz_prague_districts_grid1:} Grid of the 57 city districts of the city of Prague, Czech Republic using RUIAN IDs. Thanks to petrbouchal.
}

\itemize{
\item \strong{es_catalonia_comarques_grid1:} Grid of Comarques of Catalonia, Soain. Thanks to Storydata.
}

\itemize{
\item \strong{no_counties_grid2:} Counties of Norway in 2020. Thanks to LIVF.
}

\itemize{
\item \strong{fi_helsinki_neighborhoods_grid1:} Neighborhoods of Helsinki, Finland. Thanks to msutela.
}

\itemize{
\item \strong{us_state_without_DC_AK_HI_grid1:} Updated US state Without DC, AK and HI. Thanks to KWB4484.
}

\itemize{
\item \strong{ru_federal_subjects_grid2:} Federal Subjects of Russia. Thanks to katerinaalex.
}

\itemize{
\item \strong{us_ut_counties_grid1:} Grid of Counties of Utah, United States. Thanks to raogeorge.
}

\itemize{
\item \strong{in_state_ut_grid4:} India states and union territories facet grid. Changes compared to previous grid: now the following union territories are included as well: Chandigarh, Delhi, Lakshadweep, Andaman and Nicobar Islands, Ladakh.. Thanks to rishabhshah-92.
}

\itemize{
\item \strong{ec_prov_grid2:} Denser grid for Provinces of Ecuador including Galápagos Islands. Thanks to temporalista.
}

\itemize{
\item \strong{es_prov_grid1:} Grid of Provinces of Spain. Thanks to EstebanAnd.
}

\itemize{
\item \strong{americas_countries_grid2:} Grid of Countries of North and South America. Thanks to MathildeMousset.
}

\itemize{
\item \strong{us_nm_counties_grid1:} Grid of Counties of New Mexico, United States. Thanks to ty-sanders.
}

\itemize{
\item \strong{us_me_counties_grid1:} Grid of Counties of Maine, United States. Thanks to dikbrown.
}

\itemize{
\item \strong{cu_prov_grid1:} Grid of Provinces of Cuba and Isla de la Juventud. Thanks to accostales.
}

\itemize{
\item \strong{ge_regions_grid1:} Grid of Regions of Georgia. Thanks to nasrashvilin.
}

\itemize{
\item \strong{co_departments_grid3:} Grid of Departments of Colombia. Thanks to JOTOR.
}

\itemize{
\item \strong{gb_london_boroughs_grid2:} Boroughs of London with name wrapped to fit grid. Thanks to ICAITC.
}

\itemize{
\item \strong{gb_sct_aberdeenshire_IZ_grid1:} Grid of Scottish intermediate zones for Aberdeenshire. Thanks to waynegault.
}

\itemize{
\item \strong{gb_sct_aberdeenshire_wards_grid1:} Grid of Aberdeenshire, Scotland's Multi-member Wards. Thanks to waynegault.
}

\itemize{
\item \strong{at_vienna_districts_grid1:} Districts of Vienna, Austria. Thanks to romanseidl.
}

\itemize{
\item \strong{gh_regions_grid1:} Regions of Ghana. Thanks to Abu-sakara.
}

\itemize{
\item \strong{uy_departamentos_grid2:} Departamentos of Uruguay. Thanks to RichDeto.
}

\itemize{
\item \strong{ch_vaud_districts_grid1:} Districts for Canton of Vaud, Switzerland. Thanks to vdes2020.
}

\itemize{
\item \strong{us_ca_counties_FIPS_grid1:} Grid of Counties of California, United States with FIPS codes. Thanks to ahcyip.
}

\itemize{
\item \strong{kr_seoul_district_grid2:} Grid of Districts of Seoul, South Korea. Thanks to kjhnav.
}

\itemize{
\item \strong{kr_districts_grid1:} Administrative Districts of South Korea. Thanks to kjhnav.
}

\itemize{
\item \strong{oecd_grid2:} Grid of member countries of Organisation for Economic Co-operation and Development. Thanks to kjhnav.
}

\itemize{
\item \strong{bo_departments_grid2:} Grid of Departamentos of Bolivia. Thanks to ccsuehara.
}

\itemize{
\item \strong{ca_us_prov_state_grid2:} Grid of Provinces of Canada and States of United States. Thanks to semerson77.
}

\itemize{
\item \strong{us_il_counties_grid1:} Grid of Counties of Illinois, United States. Thanks to amsutton.
}

\itemize{
\item \strong{tn_governorates_grid1:} Grid of Governorates of Tunisia. Thanks to AminGhrabi.
}

\itemize{
\item \strong{gb_sct_glasgow_wards_grid1:} Electoral Wards of Glasgow, Scotland. Thanks to nrennie.
}

\itemize{
\item \strong{kr_provinces_grid1:} Provinces of Republic of Korea. Thanks to statkclee.
}

\itemize{
\item \strong{kr_counties_districts_cities_grid1:} South Korean metropolitan cities' districts (gu), municipal cities (si), and counties (gun). Thanks to chichead.
}

\itemize{
\item \strong{us_ok_counties_grid1:} Grid of Counties of Oklahoma, United States. Thanks to andrewvanleuven.
}

\itemize{
\item \strong{us_dc_neighborhoods_grid1:} Grid of Neighborhoods of District of Columbia, United States. Thanks to rexarski.
}

\itemize{
\item \strong{us_mn_counties_grid1:} Grid of Counties of Minnesota. Thanks to chadrent.
}
}
\keyword{data}
