% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ogc_api_nls.R
\name{ogc_get_nimisto}
\alias{ogc_get_nimisto}
\title{Query Geographic Names (Nimistö) from the National Land Survey of Finland}
\usage{
ogc_get_nimisto(
  search_string = NULL,
  collection = "placenames",
  crs = 3067,
  limit = NULL,
  bbox = NULL,
  custom_params = NULL,
  api_key = getOption("geofi_mml_api_key")
)
}
\arguments{
\item{search_string}{Character or NULL. A search string to filter place names
(e.g., \code{"kainu"}). The search is case-insensitive. If \code{NULL}
(default), no search filter is applied, and all place names are retrieved
(subject to the \code{limit} parameter).}

\item{collection}{Character or NULL. The name of collection for places, place names and map names of the
Geographic Names Register provided by the National Land Survey of Finland where the search if performed from.
Supported values are \code{placenames}, \code{mapnames}, and \code{placenames_simple}}

\item{crs}{Numeric or Character. The coordinate reference system (CRS)
for the output data, specified as an EPSG code. Supported values are
\code{3067} (ETRS-TM35FIN, default) and \code{4326} (WGS84). The returned
\code{sf} object will be transformed to this CRS.}

\item{limit}{Numeric. The maximum number of features to retrieve in a single
API request. Defaults to 10. Set to \code{NULL} to fetch all available
features (potentially using pagination for large datasets).}

\item{bbox}{Character or NULL. A bounding box to filter the data, specified as
a string in the format \code{"minx,miny,maxx,maxy"} (e.g.,
\code{"24.5,60.1,25.5,60.5"}). Coordinates must be in the same CRS as the
API (EPSG:4326). If \code{NULL} (default), no spatial filter is applied.}

\item{custom_params}{Character or NULL. Additional query parameters to append
to the API URL, specified as a single string (e.g.,
\code{"attribute='value'"}). If \code{NULL} (default), no additional
parameters are included.}

\item{api_key}{Character. API key for authenticating with the Geographic Names
OGC API. Defaults to the value stored in
\code{options(geofi_mml_api_key)}. You can obtain an API key from the
National Land Survey of Finland website (see
\url{https://www.maanmittauslaitos.fi/en/rajapinnat/api-avaimen-ohje}).}
}
\value{
An \code{sf} object containing the spatial features (place names) from
the Geographic Names dataset, transformed to the requested \code{crs}.
If no features are found, a warning is issued, and an empty \code{sf} object
may be returned.
}
\description{
Queries the Geographic Names (Nimistö) OGC API to retrieve spatial data on
place names provided by the National Land Survey of Finland (NLS).
}
\details{
This function retrieves spatial data on place names from the Geographic Names
(Nimistö) OGC API, provided by the National Land Survey of Finland (NLS). It
supports filtering by a search string (case-insensitive), spatial filtering
using a bounding box, and limiting the number of returned features.

Key features:
\itemize{
\item Supports pagination for large datasets when \code{limit=NULL}.
\item Applies spatial filtering using a bounding box (\code{bbox}).
\item Transforms the output to the specified CRS (\code{crs}).
\item Validates inputs to prevent common errors.
}
}
\examples{
\dontrun{
# Set your API key
options(geofi_mml_api_key = "your_api_key_here")

# Search for place names containing "kainu" in EPSG:3067
places <- ogc_get_nimisto(search_string = "kainu")
print(places)

# Search with a bounding box (in EPSG:4326) and transform to EPSG:4326
places_bbox <- ogc_get_nimisto(
  search_string = "kainu",
  bbox = "24.5,60.1,25.5,60.5",
  crs = 4326
)
print(places_bbox)

# Fetch all place names (no search filter) with a custom limit
all_places <- ogc_get_nimisto(
  search_string = NULL,
  limit = 100
)
print(all_places)
}

}
\seealso{
\url{https://www.maanmittauslaitos.fi/nimiston-kyselypalvelu-ogc-api/tekninen-kuvaus}
for more information on the Geographic Names dataset.
\url{https://www.maanmittauslaitos.fi/en/rajapinnat/api-avaimen-ohje} for
instructions on obtaining an API key.
}
\author{
Markus Kainu \email{markus.kainu@kapsi.fi}
}
