% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOImageryMetadata.R
\docType{class}
\name{ISOImageryMetadata}
\alias{ISOImageryMetadata}
\title{ISOImageryMetadata}
\format{
\code{\link[R6]{R6Class}} object.
}
\value{
Object of \code{\link[R6]{R6Class}} for modelling an ISO Imagery Metadata
}
\description{
ISOImageryMetadata

ISOImageryMetadata
}
\examples{
    #example 1 - WRITE: Create an ISO metadata and encode it as XML
    #######################################################
    md = ISOImageryMetadata$new()
    md$setFileIdentifier("my-metadata-identifier")
    md$setParentIdentifier("my-parent-metadata-identifier")
    md$setCharacterSet("utf8")
    md$setLanguage("eng")
    md$setDateStamp(ISOdate(2015, 1, 1, 1))
    md$setMetadataStandardName("ISO 19115:2003/19139")
    md$setMetadataStandardVersion("1.0")
    md$setDataSetURI("my-dataset-identifier")
    
    #add 3 contacts
    for(i in 1:3){
      rp <- ISOResponsibleParty$new()
      rp$setIndividualName(paste0("someone",i))
      rp$setOrganisationName("somewhere")
      rp$setPositionName(paste0("someposition",i))
      rp$setRole("pointOfContact")
      contact <- ISOContact$new()
      phone <- ISOTelephone$new()
      phone$setVoice(paste0("myphonenumber",i))
      phone$setFacsimile(paste0("myfacsimile",i))
      contact$setPhone(phone)
      address <- ISOAddress$new()
      address$setDeliveryPoint("theaddress")
      address$setCity("thecity")
      address$setPostalCode("111")
      address$setCountry("France")
      address$setEmail("someone@theorg.org")
      contact$setAddress(address)
      res <- ISOOnlineResource$new()
      res$setLinkage("http://somelink")
      res$setName("someresourcename")
      contact$setOnlineResource(res)
      rp$setContactInfo(contact)
      md$addContact(rp)
   }
   
   #VectorSpatialRepresentation
   vsr <- ISOVectorSpatialRepresentation$new()
   vsr$setTopologyLevel("geometryOnly")
   geomObject <- ISOGeometricObjects$new()
   geomObject$setGeometricObjectType("surface")
   geomObject$setGeometricObjectCount(5L)
   vsr$addGeometricObjects(geomObject)
   md$addSpatialRepresentationInfo(vsr)
   
   #ReferenceSystem
   rs <- ISOReferenceSystem$new()
   rsId <- ISOReferenceIdentifier$new(code = "4326", codeSpace = "EPSG")
   rs$setReferenceSystemIdentifier(rsId)
   md$addReferenceSystemInfo(rs)
   
   #data identification
   ident <- ISODataIdentification$new()
   ident$setAbstract("abstract")
   ident$setPurpose("purpose")
   ident$addCredit("credit1")
   ident$addCredit("credit2")
   ident$addCredit("credit3")
   ident$addStatus("completed")
   ident$addLanguage("eng")
   ident$addCharacterSet("utf8")
   ident$addTopicCategory("biota")
   ident$addTopicCategory("oceans")
   
   #adding a point of contact
   rp <- ISOResponsibleParty$new()
   rp$setIndividualName("someone")
   rp$setOrganisationName("somewhere")
   rp$setPositionName("someposition")
   rp$setRole("pointOfContact")
   contact <- ISOContact$new()
   phone <- ISOTelephone$new()
   phone$setVoice("myphonenumber")
   phone$setFacsimile("myfacsimile")
   contact$setPhone(phone)
   address <- ISOAddress$new()
   address$setDeliveryPoint("theaddress")
   address$setCity("thecity")
   address$setPostalCode("111")
   address$setCountry("France")
   address$setEmail("someone@theorg.org")
   contact$setAddress(address)
   res <- ISOOnlineResource$new()
   res$setLinkage("http://somelink")
   res$setName("somename")
   contact$setOnlineResource(res)
   rp$setContactInfo(contact)
   ident$addPointOfContact(rp)
   
   #citation
   ct <- ISOCitation$new()
   ct$setTitle("sometitle")
   d <- ISODate$new()
   d$setDate(ISOdate(2015, 1, 1, 1))
   d$setDateType("publication")
   ct$addDate(d)
   ct$setEdition("1.0")
   ct$setEditionDate(as.Date(ISOdate(2015, 1, 1, 1)))
   ct$addIdentifier(ISOMetaIdentifier$new(code = "identifier"))
   ct$addPresentationForm("mapDigital")
   ct$addCitedResponsibleParty(rp)
   ident$setCitation(ct)
   
   #graphic overview
   go1 <- ISOBrowseGraphic$new(
     fileName = "http://wwww.somefile.org/png1",
     fileDescription = "Map Overview 1",
     fileType = "image/png"
   )
   go2 <- ISOBrowseGraphic$new(
     fileName = "http://www.somefile.org/png2",
     fileDescription = "Map Overview 2",
     fileType = "image/png"
   )
   ident$addGraphicOverview(go1)
   ident$addGraphicOverview(go2)
   
   #maintenance information
   mi <- ISOMaintenanceInformation$new()
   mi$setMaintenanceFrequency("daily")
   ident$addResourceMaintenance(mi)
   
   #adding legal constraints
   lc <- ISOLegalConstraints$new()
   lc$addUseLimitation("limitation1")
   lc$addUseLimitation("limitation2")
   lc$addUseLimitation("limitation3")
   lc$addAccessConstraint("copyright")
   lc$addAccessConstraint("license")
   lc$addUseConstraint("copyright")
   lc$addUseConstraint("license")
   ident$addResourceConstraints(lc)
   
   #adding security constraints
   sc <- ISOSecurityConstraints$new()
   sc$setClassification("secret")
   sc$setUserNote("ultra secret")
   sc$setClassificationSystem("no classification in particular")
   sc$setHandlingDescription("description")
   ident$addResourceConstraints(sc)
   
   #adding extent
   extent <- ISOExtent$new()
   bbox <- ISOGeographicBoundingBox$new(minx = -180, miny = -90, maxx = 180, maxy = 90)
   extent$addGeographicElement(bbox)
   ident$addExtent(extent)
   
   #add keywords
   kwds <- ISOKeywords$new()
   kwds$addKeyword("keyword1")
   kwds$addKeyword("keyword2")
   kwds$setKeywordType("theme")
   th <- ISOCitation$new()
   th$setTitle("General")
   th$addDate(d)
   kwds$setThesaurusName(th)
   ident$addKeywords(kwds)
   
   #add an INSPIRE spatial data theme?
   inspire_kwd <- ISOKeywords$new()
   anc1 <- ISOAnchor$new(
     name = "Environmental monitoring facilities",
     href = "http://inspire.ec.europa.eu/theme/ef"
   )
   inspire_kwd$addKeyword(anc1)
   inspire_kwd$setKeywordType("theme")
   th <- ISOCitation$new()
   th$setTitle(
     ISOAnchor$new(
       name = "GEMET - INSPIRE themes, version 1.0",
       href="http://www.eionet.europa.eu/gemet/inspire_themes"
     )
   )
   inspire_date <- ISODate$new()
   inspire_date$setDate(as.Date("2008-06-01"))
   inspire_date$setDateType("publication")
   th$addDate(inspire_date)
   inspire_kwd$setThesaurusName(th)
   ident$addKeywords(inspire_kwd)
   
   #supplementalInformation
   ident$setSupplementalInformation("some additional information")
   
   #spatial representation type
   ident$addSpatialRepresentationType("vector")
   
   md$addIdentificationInfo(ident)
   
   #Distribution
   distrib <- ISODistribution$new()
   dto <- ISODigitalTransferOptions$new()  
   for(i in 1:3){
     or <- ISOOnlineResource$new()
     or$setLinkage(paste0("http://somelink",i))
     or$setName(paste0("name",i))
     or$setDescription(paste0("description",i))
     or$setProtocol("WWW:LINK-1.0-http--link")
     dto$addOnlineResource(or)
   }
   distrib$addDigitalTransferOptions(dto)
   md$setDistributionInfo(distrib)
   
   #create dataQuality object with a 'dataset' scope
   dq <- ISODataQuality$new()
   scope <- ISODataQualityScope$new()
   scope$setLevel("dataset")
   dq$setScope(scope)
  
   #add data quality reports...
  
   #add a report the data quality
   dc <- ISODomainConsistency$new()
   result <- ISOConformanceResult$new()
   spec <- ISOCitation$new()
   spec$setTitle("Data Quality check")
   spec$addAlternateTitle("This is is some data quality check report")
   d <- ISODate$new()
   d$setDate(ISOdate(2015, 1, 1, 1))
   d$setDateType("publication")
   spec$addDate(d)
   result$setSpecification(spec)
   result$setExplanation("some explanation about the conformance")
   result$setPass(TRUE)
   dc$addResult(result)
   dq$addReport(dc)
  
   #add INSPIRE reports?
   #INSPIRE - interoperability of spatial data sets and services
   dc_inspire1 <- ISODomainConsistency$new()
   cr_inspire1 <- ISOConformanceResult$new()
   cr_inspire_spec1 <- ISOCitation$new()
   cr_title1 <- paste(
     "Commission Regulation (EU) No 1089/2010 of 23 November 2010 implementing Directive 2007/2/EC",
     "of the European Parliament and of the Council as regards interoperability of spatial data",
     "sets and services"
   )
   cr_inspire_spec1$setTitle(cr_title1)
   cr_inspire1$setExplanation("See the referenced specification")
   cr_inspire_date1 <- ISODate$new()
   cr_inspire_date1$setDate(ISOdate(2010,12,8))
   cr_inspire_date1$setDateType("publication")
   cr_inspire_spec1$addDate(cr_inspire_date1)
   cr_inspire1$setSpecification(cr_inspire_spec1)
   cr_inspire1$setPass(TRUE)
   dc_inspire1$addResult(cr_inspire1)
   dq$addReport(dc_inspire1)
   #INSPIRE - metadata
   dc_inspire2 <- ISODomainConsistency$new()
   cr_inspire2 <- ISOConformanceResult$new()
   cr_inspire_spec2 <- ISOCitation$new()
   cr_title2 <- paste(
     "COMMISSION REGULATION (EC) No 1205/2008 of 3 December 2008 implementing Directive 2007/2/EC",
     "of the European Parliament and of the Council as regards metadata"
   )
   cr_inspire_spec2$setTitle(cr_title2)
   cr_inspire2$setExplanation("See the referenced specification")
   cr_inspire_date2 <- ISODate$new()
   cr_inspire_date2$setDate(ISOdate(2008,12,4))
   cr_inspire_date2$setDateType("publication")
   cr_inspire_spec2$addDate(cr_inspire_date2)
   cr_inspire2$setSpecification(cr_inspire_spec2)
   cr_inspire2$setPass(TRUE)
   dc_inspire2$addResult(cr_inspire2)
   dq$addReport(dc_inspire2)
   
   #add lineage
   lineage <- ISOLineage$new()
   lineage$setStatement("statement")
   dq$setLineage(lineage)
   
   md$addDataQualityInfo(dq)
   
   #Content Information
   #-------------------------
   #add a feature catalogue description
   fcd <- ISOFeatureCatalogueDescription$new()
   fcd$setComplianceCode(FALSE)
   fcd$addLanguage("eng")
   fcd$setIncludedWithDataset(FALSE)
   cit = ISOCitation$new()
   cit$setTitle("sometitle")
   d <- ISODate$new()
   d$setDate(ISOdate(2015, 1, 1, 1))
   d$setDateType("publication")
   cit$addDate(d)
   cit$setEdition("1.0")
   cit$setEditionDate(as.Date(ISOdate(2015, 1, 1, 1)))
   contact = ISOContact$new()
   fcLink <- ISOOnlineResource$new()
   fcLink$setLinkage("http://somelink/featurecatalogue")
   contact$setOnlineResource(fcLink)
   rp = ISOResponsibleParty$new()
   rp$setRole("publisher")
   rp$setContactInfo(contact)
   cit$addCitedResponsibleParty(rp)
   fcd$addFeatureCatalogueCitation(cit)
   md$addContentInfo(fcd)
   
   #XML representation of the ISOImageryMetadata
   xml <- md$encode()
   
   #example 2 - READ: Create an ISO imagery metadata reading from XML
   ######################################################
   \donttest{
   require(XML)
   xmlfile <- system.file("extdata/examples", "metadata.xml", package = "geometa")
   xml <- xmlParse(xmlfile)
   md <- ISOImageryMetadata$new(xml = xml)
   }

}
\references{
- 19139 \url{https://schemas.isotc211.org/19115/-2/gmi/1.0/gmi/#element_MI_Metadata}
  
  - 19115-3 \url{https://schemas.isotc211.org/19115/-3/mac/2.0/mac/#element_MI_Metadata}
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{element}
\keyword{imagery}
\keyword{metadata}
\section{Super classes}{
\code{\link[geometa:geometaLogger]{geometa::geometaLogger}} -> \code{\link[geometa:ISOAbstractObject]{geometa::ISOAbstractObject}} -> \code{\link[geometa:ISOMetadata]{geometa::ISOMetadata}} -> \code{ISOImageryMetadata}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{acquisitionInformation}}{acquisitionInformation [0..*]: ISOImageryAcquisitionInformation}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ISOImageryMetadata-new}{\code{ISOImageryMetadata$new()}}
\item \href{#method-ISOImageryMetadata-addAcquisitionInfo}{\code{ISOImageryMetadata$addAcquisitionInfo()}}
\item \href{#method-ISOImageryMetadata-delAcquisitionInfo}{\code{ISOImageryMetadata$delAcquisitionInfo()}}
\item \href{#method-ISOImageryMetadata-clone}{\code{ISOImageryMetadata$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="ERROR"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-ERROR'><code>geometa::geometaLogger$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="INFO"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-INFO'><code>geometa::geometaLogger$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="WARN"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-WARN'><code>geometa::geometaLogger$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addFieldAttrs"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addFieldAttrs'><code>geometa::ISOAbstractObject$addFieldAttrs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addListElement'><code>geometa::ISOAbstractObject$addListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="checkMetadataStandardCompliance"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-checkMetadataStandardCompliance'><code>geometa::ISOAbstractObject$checkMetadataStandardCompliance()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="contains"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-contains'><code>geometa::ISOAbstractObject$contains()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="createLocalisedProperty"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-createLocalisedProperty'><code>geometa::ISOAbstractObject$createLocalisedProperty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="decode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-decode'><code>geometa::ISOAbstractObject$decode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="delListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-delListElement'><code>geometa::ISOAbstractObject$delListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="encode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-encode'><code>geometa::ISOAbstractObject$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClass"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClass'><code>geometa::ISOAbstractObject$getClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClassName"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClassName'><code>geometa::ISOAbstractObject$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getNamespaceDefinition"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getNamespaceDefinition'><code>geometa::ISOAbstractObject$getNamespaceDefinition()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isDocument"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isDocument'><code>geometa::ISOAbstractObject$isDocument()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isFieldInheritedFrom"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isFieldInheritedFrom'><code>geometa::ISOAbstractObject$isFieldInheritedFrom()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="print"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-print'><code>geometa::ISOAbstractObject$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="save"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-save'><code>geometa::ISOAbstractObject$save()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setAttr"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setAttr'><code>geometa::ISOAbstractObject$setAttr()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeList"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeList'><code>geometa::ISOAbstractObject$setCodeList()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeListValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeListValue'><code>geometa::ISOAbstractObject$setCodeListValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeSpace"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeSpace'><code>geometa::ISOAbstractObject$setCodeSpace()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setHref"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setHref'><code>geometa::ISOAbstractObject$setHref()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setId"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setId'><code>geometa::ISOAbstractObject$setId()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setIsNull"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setIsNull'><code>geometa::ISOAbstractObject$setIsNull()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setValue'><code>geometa::ISOAbstractObject$setValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="stopIfMetadataStandardIsNot"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-stopIfMetadataStandardIsNot'><code>geometa::ISOAbstractObject$stopIfMetadataStandardIsNot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="validate"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-validate'><code>geometa::ISOAbstractObject$validate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="wrapBaseElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-wrapBaseElement'><code>geometa::ISOAbstractObject$wrapBaseElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="addAlternativeMetadataReference"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-addAlternativeMetadataReference'><code>geometa::ISOMetadata$addAlternativeMetadataReference()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="addContact"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-addContact'><code>geometa::ISOMetadata$addContact()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="addContentInfo"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-addContentInfo'><code>geometa::ISOMetadata$addContentInfo()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="addDataQualityInfo"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-addDataQualityInfo'><code>geometa::ISOMetadata$addDataQualityInfo()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="addDate"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-addDate'><code>geometa::ISOMetadata$addDate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="addHierarchyLevel"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-addHierarchyLevel'><code>geometa::ISOMetadata$addHierarchyLevel()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="addHierarchyLevelName"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-addHierarchyLevelName'><code>geometa::ISOMetadata$addHierarchyLevelName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="addIdentificationInfo"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-addIdentificationInfo'><code>geometa::ISOMetadata$addIdentificationInfo()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="addLocale"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-addLocale'><code>geometa::ISOMetadata$addLocale()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="addMetadataExtensionInfo"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-addMetadataExtensionInfo'><code>geometa::ISOMetadata$addMetadataExtensionInfo()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="addMetadataLinkage"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-addMetadataLinkage'><code>geometa::ISOMetadata$addMetadataLinkage()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="addMetadataProfile"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-addMetadataProfile'><code>geometa::ISOMetadata$addMetadataProfile()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="addMetadataScope"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-addMetadataScope'><code>geometa::ISOMetadata$addMetadataScope()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="addMetadataStandard"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-addMetadataStandard'><code>geometa::ISOMetadata$addMetadataStandard()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="addPortrayalCatalogueInfo"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-addPortrayalCatalogueInfo'><code>geometa::ISOMetadata$addPortrayalCatalogueInfo()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="addReferenceSystemInfo"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-addReferenceSystemInfo'><code>geometa::ISOMetadata$addReferenceSystemInfo()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="addResourceLineage"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-addResourceLineage'><code>geometa::ISOMetadata$addResourceLineage()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="addSpatialRepresentationInfo"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-addSpatialRepresentationInfo'><code>geometa::ISOMetadata$addSpatialRepresentationInfo()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="delAlternativeMetadataReference"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-delAlternativeMetadataReference'><code>geometa::ISOMetadata$delAlternativeMetadataReference()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="delContact"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-delContact'><code>geometa::ISOMetadata$delContact()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="delContentInfo"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-delContentInfo'><code>geometa::ISOMetadata$delContentInfo()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="delDataQualityInfo"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-delDataQualityInfo'><code>geometa::ISOMetadata$delDataQualityInfo()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="delDate"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-delDate'><code>geometa::ISOMetadata$delDate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="delHierarchyLevel"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-delHierarchyLevel'><code>geometa::ISOMetadata$delHierarchyLevel()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="delHierarchyLevelName"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-delHierarchyLevelName'><code>geometa::ISOMetadata$delHierarchyLevelName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="delIdentificationInfo"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-delIdentificationInfo'><code>geometa::ISOMetadata$delIdentificationInfo()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="delLocale"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-delLocale'><code>geometa::ISOMetadata$delLocale()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="delMetadataExtensionInfo"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-delMetadataExtensionInfo'><code>geometa::ISOMetadata$delMetadataExtensionInfo()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="delMetadataLinkage"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-delMetadataLinkage'><code>geometa::ISOMetadata$delMetadataLinkage()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="delMetadataProfile"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-delMetadataProfile'><code>geometa::ISOMetadata$delMetadataProfile()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="delMetadataScope"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-delMetadataScope'><code>geometa::ISOMetadata$delMetadataScope()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="delMetadataStandard"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-delMetadataStandard'><code>geometa::ISOMetadata$delMetadataStandard()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="delPortrayalCatalogueInfo"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-delPortrayalCatalogueInfo'><code>geometa::ISOMetadata$delPortrayalCatalogueInfo()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="delReferenceSystemInfo"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-delReferenceSystemInfo'><code>geometa::ISOMetadata$delReferenceSystemInfo()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="delResourceLineage"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-delResourceLineage'><code>geometa::ISOMetadata$delResourceLineage()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="delSpatialRepresentationInfo"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-delSpatialRepresentationInfo'><code>geometa::ISOMetadata$delSpatialRepresentationInfo()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="setCharacterSet"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-setCharacterSet'><code>geometa::ISOMetadata$setCharacterSet()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="setDataQualityInfo"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-setDataQualityInfo'><code>geometa::ISOMetadata$setDataQualityInfo()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="setDataSetURI"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-setDataSetURI'><code>geometa::ISOMetadata$setDataSetURI()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="setDateStamp"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-setDateStamp'><code>geometa::ISOMetadata$setDateStamp()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="setDefaultLocale"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-setDefaultLocale'><code>geometa::ISOMetadata$setDefaultLocale()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="setDistributionInfo"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-setDistributionInfo'><code>geometa::ISOMetadata$setDistributionInfo()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="setFileIdentifier"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-setFileIdentifier'><code>geometa::ISOMetadata$setFileIdentifier()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="setIdentificationInfo"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-setIdentificationInfo'><code>geometa::ISOMetadata$setIdentificationInfo()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="setLanguage"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-setLanguage'><code>geometa::ISOMetadata$setLanguage()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="setMetadataIdentifier"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-setMetadataIdentifier'><code>geometa::ISOMetadata$setMetadataIdentifier()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="setMetadataMaintenance"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-setMetadataMaintenance'><code>geometa::ISOMetadata$setMetadataMaintenance()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="setMetadataStandardName"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-setMetadataStandardName'><code>geometa::ISOMetadata$setMetadataStandardName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="setMetadataStandardVersion"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-setMetadataStandardVersion'><code>geometa::ISOMetadata$setMetadataStandardVersion()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="setParentIdentifier"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-setParentIdentifier'><code>geometa::ISOMetadata$setParentIdentifier()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="setParentMetadata"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-setParentMetadata'><code>geometa::ISOMetadata$setParentMetadata()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="setReferenceSystemInfo"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-setReferenceSystemInfo'><code>geometa::ISOMetadata$setReferenceSystemInfo()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOMetadata" data-id="setSpatialRepresentationInfo"><a href='../../geometa/html/ISOMetadata.html#method-ISOMetadata-setSpatialRepresentationInfo'><code>geometa::ISOMetadata$setSpatialRepresentationInfo()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOImageryMetadata-new"></a>}}
\if{latex}{\out{\hypertarget{method-ISOImageryMetadata-new}{}}}
\subsection{Method \code{new()}}{
Initializes object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOImageryMetadata$new(xml = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link[XML]{XMLInternalNode-class}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOImageryMetadata-addAcquisitionInfo"></a>}}
\if{latex}{\out{\hypertarget{method-ISOImageryMetadata-addAcquisitionInfo}{}}}
\subsection{Method \code{addAcquisitionInfo()}}{
Adds acquisition info
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOImageryMetadata$addAcquisitionInfo(acquisitionInfo)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{acquisitionInfo}}{object of class \link{ISOImageryAcquisitionInformation}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOImageryMetadata-delAcquisitionInfo"></a>}}
\if{latex}{\out{\hypertarget{method-ISOImageryMetadata-delAcquisitionInfo}{}}}
\subsection{Method \code{delAcquisitionInfo()}}{
Deletes acquisition info
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOImageryMetadata$delAcquisitionInfo(acquisitionInfo)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{acquisitionInfo}}{object of class \link{ISOImageryAcquisitionInformation}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ISOImageryMetadata-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ISOImageryMetadata-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ISOImageryMetadata$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
