#' Upper Continental Crust
#'
#' A data set containing the composition of the _Upper Continental Crust_ as given by \insertCite{taylor1995geochemical;textual}{georefdatar}
#'
#' In this work the concentrations of most elements are given in ppm and
#' some concentrations are given in wt% or ppb.\cr
#' For the sake of unity the values given in either wt% or ppb where converted
#' to ppm. So all listed values are in ppm.\cr
#' This conversion was done using:
#' *  `ppm= wt% * 10000`
#' *  `ppm= ppb / 1000`
#'
#' @format A data frame with 1 row and `r ncol(CC_Upper__Taylor_McLennan__1995)` element concentrations in ppm. These elements are:\cr
#' `r paste(colnames(CC_Upper__Taylor_McLennan__1995), collapse= ', ')`
#'
#'
#'
#' @references{
#'   \insertRef{taylor1995geochemical}{georefdatar}
#' }
#'
#' @importFrom Rdpack reprompt
"CC_Upper__Taylor_McLennan__1995"




#' Bulk Continental Crust
#'
#' A data set containing the composition of the _Bulk Continental Crust_ as given by \insertCite{taylor1995geochemical;textual}{georefdatar}
#'
#' In this work the concentrations of most elements are given in ppm and
#' some concentrations are given in wt% or ppb.\cr
#' For the sake of unity the values given in either wt% or ppb where converted
#' to ppm. So all listed values are in ppm.\cr
#' This conversion was done using:
#' *  `ppm= wt% * 10000`
#' *  `ppm= ppb / 1000`
#'
#' @format A data frame with 1 row and `r ncol(CC_Bulk__Taylor_McLennan__1995)` element concentrations in ppm. These elements are:\cr
#' `r paste(colnames(CC_Bulk__Taylor_McLennan__1995), collapse= ', ')`
#'
#'
#'
#' @references{
#'   \insertRef{taylor1995geochemical}{georefdatar}
#' }
#'
#' @importFrom Rdpack reprompt
"CC_Bulk__Taylor_McLennan__1995"




#' Lower Continental Crust
#'
#' A data set containing the composition of the _Lower Continental Crust_ as given by \insertCite{taylor1995geochemical;textual}{georefdatar}
#'
#' In this work the concentrations of most elements are given in ppm and
#' some concentrations are given in wt% or ppb.\cr
#' For the sake of unity the values given in either wt% or ppb where converted
#' to ppm. So all listed values are in ppm.\cr
#' This conversion was done using:
#' *  `ppm= wt% * 10000`
#' *  `ppm= ppb / 1000`
#'
#' @format A data frame with 1 row and `r ncol(CC_Lower__Taylor_McLennan__1995)` element concentrations in ppm. These elements are:\cr
#' `r paste(colnames(CC_Lower__Taylor_McLennan__1995), collapse= ', ')`
#'
#'
#'
#' @references{
#'   \insertRef{taylor1995geochemical}{georefdatar}
#' }
#'
#' @importFrom Rdpack reprompt
"CC_Lower__Taylor_McLennan__1995"
