% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IsotopicRatios.R
\docType{data}
\name{isoRatios}
\alias{isoRatios}
\title{Isotopic rations}
\format{
A data frame with 3 rows and the following
4 columns:\cr
\enumerate{
\item \code{name}  of the isotopic ratio -- twice the element symbol and mass number
\item \code{value} it's value and
\item \code{err}   uncertainty as given by the reference. Uncertainty may be \code{NA} if
not stated.
\item \code{refkey}  key to reference. Also makes the entry in this table unique if
there is more than one ratio for the isotopes
}

The following isotopic ratios are included:\cr
\itemize{
\item Ar40Ar36
\item U238U235\cr
}

Some of them are included more than once in this table because their values
changed over time or are still under discussion.
}
\usage{
isoRatios
}
\description{
A data set containing some isotopic ratios regular used in earth science
}
\references{
{
\insertRef{Steiger1977}{georefdatar}

\insertRef{Lee2006}{georefdatar}

\insertRef{Hiess2012}{georefdatar}
}
}
\keyword{datasets}
