% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/path_singboost.R
\name{path.singboost}
\alias{path.singboost}
\title{Coefficient paths for SingBoost}
\usage{
path.singboost(
  D,
  M = 10,
  m_iter = 100,
  kap = 0.1,
  singfamily = Gaussian(),
  best = 1,
  LS = FALSE
)
}
\arguments{
\item{D}{Data matrix. Has to be an \eqn{n \times (p+1)-}dimensional data frame in the format \eqn{(X,Y)}. The \eqn{X-}part must not
contain an intercept column containing only ones since this column will be added automatically.}

\item{M}{An integer between 2 and \code{m_iter}. Indicates that in every \eqn{M-}th iteration, a singular iteration will be
performed. Default is 10.}

\item{m_iter}{Number of SingBoost iterations. Default is 100.}

\item{kap}{Learning rate (step size). Must be a real number in \eqn{]0,1]}. Default is 0.1 It is recommended to use
a value smaller than 0.5.}

\item{singfamily}{A Boosting family corresponding to the target loss function. See .\code{mboost} for families
corresponding to standard loss functions. May also use the loss functions for ranking losses provided in this
package. Default is \code{Gaussian()} for which SingBoost is just standard \eqn{L_2-}Boosting.}

\item{best}{Needed in the case of localized ranking. The parameter \code{K} of the localized ranking loss will be
computed by \eqn{best \cdot n} (rounded to the next larger integer). Warning: If a parameter \code{K} is inserted into the
\code{LocRank} family, it will be ignored when executing SingBoost.}

\item{LS}{If a \code{singfamily} object that is already provided by \code{mboost} is used, the respective Boosting algorithm
will be performed in the singular iterations if \code{Ls} is set to \code{TRUE}. Default is \code{FALSE}.}
}
\value{
\item{Selected variables}{Names of the selected variables.}
\item{Coefficients}{The selected coefficients as an \eqn{(p+1)-}dimensional vector (i.e., including the zeroes).}
\item{Freqs}{Selection frequencies and a matrix for intercept and coefficient paths, respectively.}
\item{Intercept path}{The intercept path as an \eqn{m_{iter}-}dimensional vector.}
\item{Coefficient path}{The coefficient paths as a \eqn{2 \cdot m_{iter} \times 2-}dimensional matrix.}
}
\description{
{Runs SingBoost but saves the coefficients paths. If no coefficient path plot is needed, just use
\code{singboost}.}
}
