% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotateTextX.R
\name{rotateTextX}
\alias{rotateTextX}
\title{Rotate x axis labels}
\usage{
rotateTextX(angle = 90, hjust = 1, vjust = 0.5)
}
\arguments{
\item{angle}{Angle (in [0, 360])}

\item{hjust}{Horizontal justification (in [0, 1])}

\item{vjust}{Vertical justification (in [0, 1])}
}
\value{
A ggplot2 layer that can be added to an existing ggplot2 object.
}
\description{
Rotate the labels on the x axis to be rotated so that they are vertical,
which is often useful when there are many overlapping labels along the x
axis.
}
\details{
This function is quite simple, but it can be useful if you don't have
the exact syntax to do this engraved in your head.
}
\examples{
df <- data.frame(x = paste("Letter", LETTERS, sep = "_"),
                 y = seq_along(LETTERS))
p <- ggplot2::ggplot(df, ggplot2::aes(x, y)) + ggplot2::geom_point()
p + rotateTextX()
}
