% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_catchcurve.R
\name{plot_catchcurve}
\alias{plot_catchcurve}
\title{Plot catch curve}
\usage{
plot_catchcurve(
  dt,
  age = "age",
  sex = "sex",
  time = NULL,
  age.range = NULL,
  female.sex = "F",
  male.sex = "M",
  split.by.sex = FALSE,
  base_size = 8,
  legend.position = "bottom"
)
}
\arguments{
\item{dt}{A data.frame, tibble or data.table}

\item{age}{Character argument giving the name of the age column in \code{dt}}

\item{sex}{Character argument giving the name of the sex column in \code{dt}. Ignored if \code{split.by.sex == FALSE}.}

\item{time}{Split analysis by time? If \code{NULL}, all data are assumed to stem from one time point. Using a character argument giving the name of a time column splits the analysis by unique values in that column and produces a faceted plot.}

\item{age.range}{Defines the age range to be used for Z estimation. If \code{NULL}, all ages are used. If a numeric vector of length 2, the first number defines the minimum age to include and the last number the maximum age. It is also possible to use differing ranges by sex when \code{split.by.sex = TRUE}: use a named list  of length two with names referring to \code{female.sex} and \code{male.sex}. Provide a numeric vector of length 2 to each element (first number defining the minimum age to include and the last number the maximum age). See Examples.}

\item{female.sex, male.sex}{A character or integer denoting female and male sex in the \code{sex} column of \code{dt}, respectively.}

\item{split.by.sex}{Logical indicating whether the result should be split by sex.}

\item{base_size}{Base size parameter for ggplot. See \link[ggplot2]{ggtheme}.}

\item{legend.position}{Position of the ggplot legend as a character. See \link[ggplot2]{ggtheme}.}
}
\description{
Plot a catch curve to estimate instantaneous total mortality (Z) using age data
}
\details{
Calculates and plots the basic log-linearized catch curve to estimate instantaneous mortality. See e.g. \href{https://www.fishbase.se/manual/english/FishBaseThe_LENGTH_WEIGHT_Table.htm}{Ogle (2013)}.
}
\examples{
# Catch curve including all ages
data(survey_ghl)
plot_catchcurve(survey_ghl)
\donttest{
# Specific ages
plot_catchcurve(survey_ghl, age.range = c(10,26))
# Split by sex
plot_catchcurve(survey_ghl, age.range = c(10,26), split.by.sex = TRUE)
# Split by sex, separate age.range
plot_catchcurve(survey_ghl,
age.range = list("F" = c(13,26), "M" = c(10,26)),
split.by.sex = TRUE)
}
}
\author{
Mikko Vihtakari // Institute of Marine Research.
}
