% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_dag.R
\name{tidy_dagitty}
\alias{tidy_dagitty}
\title{Tidy a \code{dagitty} object}
\usage{
tidy_dagitty(.dagitty, seed = NULL, layout = "nicely", ...)
}
\arguments{
\item{.dagitty}{a \code{dagitty}}

\item{seed}{a numeric seed for reproducible layout generation}

\item{layout}{a layout available in \code{ggraph}. See \code{\link[ggraph:ggraph]{ggraph::create_layout()}}
for details. Alternatively, \code{"time_ordered"} will use
\code{time_ordered_coords()} to algorithmically sort the graph by time.}

\item{...}{optional arguments passed to \code{ggraph::create_layout()}}
}
\value{
a \code{tidy_dagitty} object
}
\description{
Tidy a \code{dagitty} object
}
\examples{
library(dagitty)
library(ggplot2)

dag <- dagitty("dag {
  Y <- X <- Z1 <- V -> Z2 -> Y
  Z1 <- W1 <-> W2 -> Z2
  X <- W1 -> Y
  X <- W2 -> Y
  X [exposure]
  Y [outcome]
  }")

tidy_dagitty(dag)

tidy_dagitty(dag, layout = "fr") \%>\%
  ggplot(aes(x = x, y = y, xend = xend, yend = yend)) +
  geom_dag_node() +
  geom_dag_text() +
  geom_dag_edges() +
  theme_dag()
}
