#' @importFrom ggplot2 ggproto StatDensity
#' @rdname geom_count_sample
#' @format NULL
#' @usage NULL
#' @export
StatDensitySample <- ggproto("StatDensitySample", ggplot2::StatDensity,
                             setup_data = function(data, params) {
                               dibble_to_tibble(data, params)
                             },
                             extra_params = c("na.rm", "times", "seed")
                               
)
            
#' @importFrom ggplot2 make_constructor GeomDensity
#' @inheritParams ggplot2::geom_density
#' @rdname geom_density_sample
#' @export
stat_density_sample <- make_constructor(
  StatDensitySample, geom = "area", orientation = NA, seed = NULL,
  position = "stack_identity",times=10)




  