library(vdiffr)
library(ggplot2)
library(distributional)
library(dplyr)

# Extra data for last example
df <- expand.grid(x = 0:5, y = 0:5)
set.seed(1)
df$z <- runif(nrow(df))
uncertain_df <- df |> 
  group_by(x,y) |>
  mutate(z = dist_normal(z, runif(1, 0, 0.1))) |>
  ungroup()


test_that("geom_raster_sample tests", {
  
  set.seed(342)
  p1 <- ggplot(uncertain_faithfuld, aes(waiting, eruptions)) + 
    geom_raster_sample(aes(fill = density), times=2) 
  expect_doppelganger("Example 1", p1)
  
  p5 <- ggplot(uncertain_df, aes(x, y, fill = z)) +
    geom_raster_sample(hjust = 0, vjust = 0, times=2)
  expect_doppelganger("Example 5", p5)
}
)
