% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggdist-package.R
\docType{package}
\name{ggdist-package}
\alias{ggdist-package}
\alias{ggdist}
\title{Visualizations of Distributions and Uncertainty}
\description{
\code{ggdist} is an R package that aims to make it easy to integrate
popular Bayesian modeling methods into a tidy data + ggplot workflow.
}
\details{
\code{ggdist} is an R package that provides a flexible set of \code{ggplot2} geoms and stats designed
especially for visualizing distributions and uncertainty. It is designed for both
frequentist and Bayesian uncertainty visualization, taking the view that uncertainty
visualization can be unified through the perspective of distribution visualization:
for frequentist models, one visualizes confidence distributions or bootstrap distributions
(see \code{vignette("freq-uncertainty-vis")}); for Bayesian models, one visualizes probability
distributions (see \code{vignette("tidybayes", package = "tidybayes")}).

The \code{\link[=geom_slabinterval]{geom_slabinterval()}} / \code{\link[=stat_slabinterval]{stat_slabinterval()}} family (see \code{vignette("slabinterval")}) makes it
easy to visualize point summaries and intervals, eye plots, half-eye plots, ridge plots,
CCDF bar plots, gradient plots, histograms, and more.

The \code{\link[=geom_dotsinterval]{geom_dotsinterval()}} / \code{\link[=stat_dotsinterval]{stat_dotsinterval()}} family (see \code{vignette("dotsinterval")}) makes
it easy to visualize dot+interval plots, Wilkinson dotplots, beeswarm plots, and quantile dotplots.

The \code{\link[=geom_lineribbon]{geom_lineribbon()}} / \code{\link[=stat_lineribbon]{stat_lineribbon()}} family (see \code{vignette("lineribbon")})
makes it easy to visualize fit lines with an arbitrary number of uncertainty bands.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://mjskay.github.io/ggdist/}
  \item \url{https://github.com/mjskay/ggdist/}
  \item Report bugs at \url{https://github.com/mjskay/ggdist/issues}
}

}
\author{
\strong{Maintainer}: Matthew Kay \email{mjskay@northwestern.edu}

Other contributors:
\itemize{
  \item Brenton M. Wiernik \email{brenton@wiernik.org} [contributor]
}

}
