% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_subgene_label.R
\name{geom_subgene_label}
\alias{geom_subgene_label}
\title{A 'ggplot2' geom to add text labels to subgenes}
\usage{
geom_subgene_label(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = TRUE,
  padding.x = grid::unit(1, "mm"),
  padding.y = grid::unit(0.1, "lines"),
  align = "centre",
  min.size = 4,
  grow = F,
  reflow = F,
  height = grid::unit(3, "mm"),
  ...
)
}
\arguments{
\item{mapping, data, stat, position, na.rm, show.legend, inherit.aes, ...}{Standard
geom arguments as for \code{ggplot2::geom_text()}.}

\item{padding.x, padding.y}{\code{grid::unit()} object, giving horizontal or
vertical padding around the text. Defaults to 1 mm and 0.1 lines
respectively.}

\item{align}{Where inside the subgene to place the text label. Default is
'centre'; other options are 'left' and 'right'.}

\item{min.size}{Minimum font size, in points. If provided, text that would
need to be shrunk below this size to fit inside the subgene will not be
drawn. Defaults to 4 pt.}

\item{grow}{If \code{TRUE}, text will be grown as well as shrunk to fill the
subgene.}

\item{reflow}{If \code{TRUE}, text will be reflowed (wrapped) to better fit the
subgene.}

\item{height}{\code{grid::unit()} object giving the maximum height of the text.
Defaults to 3 mm, which is the default height of gene arrows (and therefore
of subgenes) drawn with \code{geom_gene_arrow()}.}
}
\description{
\code{geom_subgene_label()} can be used to add a text label to subgenes drawn
with \code{geom_subgene_arrow()}.
}
\details{
\code{geom_subgene_label()} uses the 'ggfittext' package to fit text to genes.
All text drawing options available in \code{ggfittext::geom_fit_text()} (growing,
reflowing, etc.) are also available here. For full details on how these
options work, see the documentation for \code{ggfittext::geom_fit_text()}.

Standard 'ggplot2' aesthetics for text are supported (see Aesthetics.)
}
\section{Aesthetics}{

\itemize{
\item xsubmin,xsubmax (start and end of the subgene; required)
\item y (molecule; required)
\item colour
\item size
\item alpha
\item family
\item fontface
\item angle
}
}

