% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ghost.R
\name{-.gg}
\alias{-.gg}
\title{Remove a call from a ggghost object}
\usage{
\method{-}{gg}(e1, e2)
}
\arguments{
\item{e1}{An object of class \code{ggghost}}

\item{e2}{A component to remove from \code{e1} as either a string or a
language object}
}
\value{
A \code{ggghost} structure with calls (text) matching \code{e2}
removed, otherwise the same as \code{e1}
}
\description{
Calls can be removed from the \code{ggghost} object via regex matching of the
function name. All matching calls will be removed based on the match to the
string up to the first bracket, so any arguments are irrelevant.
}
\details{
For example, subtracting \code{geom_line()} will remove all calls matching
\code{geom_line} regardless of their arguments.

\code{labs()} has been identified as a special case, as it requires an argument in
order to be recognised as a valid function. Thus, trying to remove it with an
empty argument will fail. That said, the argument doesn't need to match, so
it can be populated with a dummy string or anything that evaluates in scope.
See examples.
}
\examples{
## create a ggghost object
tmpdata <- data.frame(x = 1:100, y = rnorm(100))

z \%g<\% ggplot(tmpdata, aes(x,y))
z <- z + geom_point(col = "steelblue")
z <- z + theme_bw()
z <- z + labs(title = "My cool ggplot")
z <- z + labs(x = "x axis", y = "y axis")
z <- z + geom_smooth()

z - "labs"        # removes all labs
z - "title"       # removes just the title
z - "axis"        # removes the axis labels
z - geom_point()  # removes points
z - theme_bw()    # removes theme_bw()
}
