% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_hour_date.R
\name{get_hour}
\alias{get_hour}
\alias{get_date}
\title{Functions to split datetime into date and time of day}
\usage{
get_hour(x, hour_center = 0, ...)

get_date(x, hour_center = 0, ...)
}
\arguments{
\item{x}{A datetime object (e.g., \code{\link[=as.POSIXct]{as.POSIXct()}}) to extract day of time
from}

\item{hour_center}{The hour at which the time of day is centred. Default is 0,
meaning midnight. -12 centres around noon of the preceding day, +12 centres
around noon of the next day.}

\item{...}{Ignored}
}
\value{
Returns a \code{period} (\code{\link[lubridate:as.period]{lubridate::as.period()}}) in case of \code{get_hour()}.
Returns a datetime object in case of \code{get_date()}
}
\description{
Split a datetime object in a date component (\code{get_date()}) and
time of day (\code{get_hour()}) component, centred around a specific
hour of the day. They are used by \code{stat_hourglass()}.
}
\examples{
my_datetime <- as.POSIXct("2020-02-02 02:20:02 UTC", tz = "UTC")
get_hour(my_datetime)
get_hour(my_datetime, -12)

get_date(my_datetime)
get_date(my_datetime, -12)

## This will return the original `my_date`
get_date(my_datetime) + get_hour(my_datetime)

## This will too
get_date(my_datetime, -12) + get_hour(my_datetime, -12)
}
\author{
Pepijn de Vries
}
