% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isotonic.R
\name{stat_isotonic}
\alias{stat_isotonic}
\title{stat from isotonic regression}
\usage{
stat_isotonic(
  mapping = NULL,
  data = NULL,
  geom = "line",
  position = "identity",
  show.legend = NA,
  inherit.aes = TRUE,
  precision = 4,
  increasing = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{The geometric object to use display the data}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{precision}{Round 'x' with some precision to remove duplicates values}

\item{increasing}{(bool) Whether y increases with x (isotonic)}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}
}
\value{
Returns a object of class 'gg', 'ggplot'
}
\description{
Adds a stat with isotonic or monotonic regression based on
  `fdrtool::monoreg` with optional weights
}
\examples{
library("ggplot2")
set.seed(100)
dataset = data.frame(x = sort(runif(1e2)),
                  y = c(rnorm(1e2/2), rnorm(1e2/2, mean = 4)),
                  w = sample(1:3, 1e2, replace = TRUE)
                  )

# plot isotonic regression line
ggplot(dataset, aes(x = x, y = y)) +
 geom_point() +
 stat_isotonic()

# plot weighted isotonic regression line along with facets
ggplot(dataset, aes(x = x, y = y)) +
 geom_point() +
 stat_isotonic(aes(w = w), color = 'red', size = 1.5, show.legend = FALSE) +
 facet_wrap(w ~ .)

}
