% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{predict.ggmix_gic}
\alias{predict.ggmix_gic}
\alias{coef.ggmix_gic}
\title{Make predictions from a \code{ggmix_gic} object}
\usage{
\method{predict}{ggmix_gic}(object, newx, s = c("lambda.min"), ...)

\method{coef}{ggmix_gic}(object, s = c("lambda.min"), type, ...)
}
\arguments{
\item{object}{fitted \code{ggmix_gic} object}

\item{newx}{matrix of values for \code{x} at which predictions are to be
made. Do not include the intercept. Must be a matrix. This argument is not
used for \code{type = c("coefficients","nonzero","all")}. This matrix must
have the same number of columns originally supplied to the
\code{\link{ggmix}} fitting function.}

\item{s}{Value(s) of the penalty parameter \code{lambda} at which predictions
are required. Default is the value \code{s="lambda.min"} can be used. If
\code{s} is numeric, it is taken as the value(s) of \code{lambda} to be
used.}

\item{...}{other arguments passed to \code{\link{predict.ggmix_fit}}}

\item{type}{Type of prediction required. Type \code{"link"} gives the fitted
values \eqn{X \beta}. Type \code{"response"} is equivalent to type
\code{"link"}. Type \code{"coefficients"} computes the coefficients at the
requested values for \code{s} and returns the regression coefficients only,
including the intercept. Type \code{"all"} returns both the regression
coefficients and variance components at the requested value of \code{s}.
Type \code{"nonzero"} returns a 1 column matrix of the the nonzero fixed
effects, as well as variance components for each value of \code{s}. If more
than one \code{s} is provided, then \code{"nonzero"} will return a list of
1 column matrices. Default: "link"}
}
\value{
The object returned depends the ... argument which is passed on to
  the predict method for \code{ggmix_fit} objects.
}
\description{
This function makes predictions from a \code{ggmix_gic} object,
  using the stored "ggmix_fit" object, and the optimal value chosen for
  lambda using the gic.
}
\details{
This function makes it easier to use the results of gic chosen model
  to make a prediction.
}
\seealso{
\code{\link{predict.ggmix_fit}}
}
