% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggnuplot.R
\name{theme_gnuplot}
\alias{theme_gnuplot}
\title{gnuplot theme for ggplot2}
\usage{
theme_gnuplot(
  base_size = 11,
  base_family = "",
  base_line_size = base_size/22,
  base_rect_size = base_size/22
)
}
\arguments{
\item{base_size}{base font size}

\item{base_family}{base font family}

\item{base_line_size}{base size for line elements}

\item{base_rect_size}{base size for rect elements}
}
\description{
This theme makes ggplot2 look like gnuplot.
It is based on \code{\link[ggplot2:ggtheme]{ggplot2::theme_linedraw()}}
and has inward ticks.
}
\examples{
library(ggplot2)

ggplot(iris, aes(Sepal.Width, Sepal.Length, color = Species)) +
  geom_point() +
  scale_color_gnuplot() +
  scale_x_gnuplot() +
  scale_y_gnuplot() +
  theme_gnuplot()

}
\seealso{
The \link[ggplot2:ggtheme]{default ggplot2 themes} and \code{\link[ggplot2:theme]{ggplot2::theme()}}
}
