% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-pcp.r
\name{aes_pcp}
\alias{aes_pcp}
\title{Wrapper for aes defaults}
\usage{
aes_pcp(
  x = pcp_x,
  y = pcp_y,
  yend = pcp_yend,
  class = pcp_class,
  group = pcp_id,
  level = pcp_level,
  label = pcp_level,
  ...
)
}
\arguments{
\item{x}{x axis}

\item{y}{y axis}

\item{yend}{end point of line segment}

\item{class}{specifying type of the variable}

\item{group}{identifier}

\item{level}{character string of factor levels}

\item{label}{label for factors}

\item{...}{other aesthetics are directly passed on to \code{ggplot2}'s mapping}
}
\value{
a list of default mappings for all required aesthetics
}
\description{
The function provides a mapping from \code{ggpcp} internal variable names to the
variables' functional purpose in the grammar of graphics framework. Any of
the defaults can be overwritten by the user or flexibly expanded by other
aesthetic mappings in the usual manner.
}
\examples{
library(ggplot2)
iris |>
  pcp_select(tidyselect::everything()) |>
  pcp_scale() |>
  pcp_arrange() |>
  ggplot(aes_pcp(colour = Species)) +
    geom_pcp() +
    theme_pcp()
}
\seealso{
\code{\link[ggplot2:aes]{ggplot2::aes()}}
}
