% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quant-helper-fun.R
\name{quant_helper_fun}
\alias{quant_helper_fun}
\title{Helper function for fitting quantile regression}
\usage{
quant_helper_fun(
  data,
  formula = y ~ x,
  quantiles = c(0.25, 0.5, 0.75),
  fit.by.quantile = FALSE,
  method,
  method.name,
  method.args = list(),
  n.min = 3L,
  fit.seed = NA,
  weight = 1,
  na.rm = FALSE,
  orientation = "x"
)
}
\arguments{
\item{data}{A layer specific dataset, only needed if you want to override the
plot defaults.}

\item{formula}{a formula object. Using aesthetic names \code{x} and \code{y}
instead of original variable names.}

\item{quantiles}{numeric vector Values in 0..1 indicating the quantiles.}

\item{fit.by.quantile}{logical If TRUE return a separate fitted model
object for each quantile as needed for predictions with confidence bands.}

\item{method}{function or character If character, "rq", "rqss" or the name of
a model fit function are accepted, possibly followed by the fit function's
\code{method} argument separated by a colon (e.g. \code{"rq:br"}). If a
function different to \code{rq()}, it must accept arguments named
\code{formula}, \code{data}, \code{weights}, \code{tau} and \code{method}
and return a model fit object of class \code{rq}, \code{rqs} or
\code{rqss}.}

\item{method.args}{named list with additional arguments passed to
\code{rq()}, \code{rqss()} or to another function passed as argument to
\code{method}.}

\item{n.min}{integer Minimum number of distinct values in the explanatory
variable (on the rhs of formula) for fitting to the attempted.}

\item{fit.seed}{RNG seed argument passed to
\code{\link[base:Random]{set.seed}()}. Defaults to \code{NA}, indicating
that \code{set.seed()} should not be called.}

\item{na.rm}{a logical indicating whether NA values should be stripped before
the computation proceeds.}

\item{orientation}{character Either "x" or "y" controlling the default for
\code{formula}. The letter indicates the aesthetic considered the
explanatory variable in the model fit.}
}
\value{
A list, with members fm1, fm2, ... one for each fitted model and
  fun.args1, fun.args2, ... with arguments passed in each call to the
  model fit function.
}
\description{
Factored out code used in both stat_quant_line(), stat_quant_band()
and stat_quant_eq().
}
\details{
This function does the model fitting and returns a fitted model object. It
decodes the method, sorts the quantiles and does the fit.
}
\examples{

ggpmisc:::quant_helper_fun(data.frame(x = mpg$displ, y = mpg$hwy), method = "br")

}
\keyword{internal}
