% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position-dodge-nudge-to.R
\name{position_nudge_to}
\alias{position_nudge_to}
\title{Nudge labels to new positions}
\usage{
position_nudge_to(
  x = NULL,
  y = NULL,
  x.action = c("none", "spread"),
  y.action = c("none", "spread"),
  x.distance = "equal",
  y.distance = "equal",
  x.expansion = 0,
  y.expansion = 0,
  kept.origin = c("original", "none")
)
}
\arguments{
\item{x, y}{Coordinates of the destination position. A vector of mode
\code{numeric}, that is extended if needed, to the same length as rows
there are in \code{data}. The default, \code{NULL}, leaves the original
coordinates unchanged.}

\item{x.action, y.action}{character string, one of \code{"none"}, or
\code{"spread"}. With \code{"spread"} distributing the positions
within the range of argument \code{x} or \code{y}, if non-null. Otherwise,
using the range the variable mapped to \emph{x} or \code{y}.}

\item{x.distance, y.distance}{character or numeric Currently only
\code{"equal"} is implemented, indicating equal spacing between the
spread positions.}

\item{x.expansion, y.expansion}{numeric vectors of length 1 or 2, as a
fraction of width of the range used to spread positions.}

\item{kept.origin}{One of \code{"original"} or \code{"none"}.}
}
\value{
A \code{"Position"} object.
}
\description{
\code{position_nudge_to()} differs from \code{\link[ggplot2]{position_nudge}}
in that the coordinates of the new position are given directly, rather than
as a displacement from the original location. It optionally sets an even
spacing among positions within a range. As with other position functions in
this package, the original positions are preserved to allow the text or
labels to be linked back to their original position with a segment or arrow.
}
\details{
The nudged to
  \code{x} and/or \code{y} values replace the original ones in
  \code{data}, while the original coordinates are returned in
  \code{x_orig} and \code{y_orig}. Nudge values supported are those of
  \emph{mode} numeric, thus including dates and times when they match the
  mapped data.

  If the length of \code{x} and/or \code{y} is more than one but less than
  the rows present in the \code{data}, the vector is both recycled and
  reordered so that the nudges are applied sequentially based on the data
  values. If their length matches the number of rows in \code{data}, they are
  assumed to be already in \code{data} order.

  Irrespective of the action, the ordering of rows in \code{data} is
  preserved.
}
\note{
The current implementation DOES NOT support flipping geoms with the
\code{orientation} argument or implicitly by the mapping. It DOES NOT
apply scale transformations when spreading the positions.
}
\examples{
# The examples below exemplify the features of position_nudge_to().
# Please see the vignette for examples of use cases.

df <- data.frame(
  x = c(1,3,2,5,4,2.5),
  y = c(2, 3, 2.5, 1.8, 2.8, 1.5),
  grp = c("A", "A", "A", "B", "B", "B"),
  grp.inner = c("a", "b", "c", "a", "b", "c"),
  label = c("abc","cd","d","c","bcd","a")
)

# default is no nudging
ggplot(df, aes(label, y, label = y)) +
  geom_col() +
  geom_text(position = position_nudge_to(),
            vjust = -0.2)

# a single y (or x) value nudges all observations to this data value
ggplot(df, aes(label, y, label = y)) +
  geom_col() +
  geom_label(position = position_nudge_to(y = 1))

ggplot(df, aes(x, y, label = label)) +
  geom_point() +
  geom_text(position = position_nudge_to(y = 3.2))

ggplot(df, aes(x, y, label = label)) +
  geom_point() +
  geom_line() +
  geom_text(position = position_nudge_to(y = 0.1))

# with a suitable geom, segments or arrows can be added
ggplot(df, aes(x, y, label = label)) +
  geom_point() +
  geom_text_s(position = position_nudge_to(y = 2.25))

# alternating in y value order because y has fewer values than rows in data
ggplot(df, aes(x, y, label = label)) +
  geom_point() +
  geom_text_s(position = position_nudge_to(y = c(3, 0.1)))

# in data row order with as many nudge y values as rows in data
ggplot(df, aes(x, y, label = label)) +
  geom_point() +
  geom_text_s(position = position_nudge_to(y = c(1.8, 2.3, 1.3, 2.8, 3, 0.1)))

# spread the values at equal distance within the available space
ggplot(df, aes(x, y, label = label)) +
  geom_point() +
  geom_text_s(position =
                position_nudge_to(y = 4, x.action = "spread"))

ggplot(df, aes(x, y, label = label)) +
  geom_point() +
  geom_text_s(position =
                position_nudge_to(y = 4, x.action = "spread")) +
scale_x_log10()

# spread the values at equal distance within the expanded available space
ggplot(df, aes(x, y, label = label)) +
  geom_point() +
  geom_text_s(position =
                position_nudge_to(y = 4, x.action = "spread", x.expansion = 0.1))

# spread the values at equal distance within the range given by x
ggplot(df, aes(x, y, label = label)) +
  geom_point() +
  geom_text_s(position =
                position_nudge_to(y = 4, x = c(1.5, 4), x.action = "spread"))

# currently if scale transformations are used, the x and/or y arguments must
# be transformed. WARNING: This will change in the near future!!

ggplot(df, aes(x, y, label = label)) +
  geom_point() +
  geom_text_s(position =
                position_nudge_to(y = 4, x = log10(c(1.5, 4)), x.action = "spread")) +
scale_x_log10()

ggplot(df, aes(x, y, label = label)) +
  geom_point() +
  geom_text_s(position =
                position_nudge_to(y = log10(4), x.action = "spread")) +
scale_y_log10()

}
\seealso{
\code{\link[ggplot2]{position_nudge}},
  \code{\link[ggrepel]{position_nudge_repel}}.

Other position adjustments: 
\code{\link{position_dodgenudge}()},
\code{\link{position_dodgenudge_to}()},
\code{\link{position_jitternudge}()},
\code{\link{position_nudge_center}()},
\code{\link{position_nudge_keep}()},
\code{\link{position_nudge_line}()},
\code{\link{position_stacknudge}()},
\code{\link{position_stacknudge_to}()}
}
\concept{position adjustments}
