% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gglist.R
\name{gglist}
\alias{gglist}
\title{Generate a list of ggplots from a list of data.frames}
\usage{
gglist(
  data = NULL,
  mapping = ggplot2::aes(),
  ...,
  environment = parent.frame()
)
}
\arguments{
\item{data}{A list of data.frames (or similar objects)}

\item{mapping}{Default list of aesthetic mappings to use for plot.
If not specified, must be supplied in each layer added to the plot.}

\item{...}{Other arguments passed on to methods. Not currently used.}

\item{environment}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Used prior to tidy
evaluation.}
}
\value{
A list of ggplot2 objects
}
\description{
Generate a list of ggplots from a list of data.frames
}
\examples{
mydata <-
  list(
    data.frame(x = 1:3, y = 3:1),
    data.frame(x = 4:7, y = 7:4)
  )
gglist(mydata, ggplot2::aes(x = x, y = y)) +
  ggplot2::geom_point()
}
