% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save.R
\name{save_ggplot}
\alias{save_ggplot}
\title{Save a ggplot}
\usage{
save_ggplot(
  plot,
  file,
  device = NULL,
  scale = NULL,
  width = NULL,
  height = NULL,
  units = NULL,
  dpi = NULL,
  limitsize = TRUE,
  bg = NULL,
  create.dir = FALSE,
  ...
)
}
\arguments{
\item{plot}{The ggplot object to save.}

\item{file}{File to save the plot to.}

\item{device}{Device to use. Can either be a device function
(e.g. \link{png}), or one of "eps", "ps", "tex" (pictex),
"pdf", "jpeg", "tiff", "png", "bmp", "svg" or "wmf" (windows only). If
\code{NULL} (default), the device is guessed based on the \code{filename} extension.}

\item{scale}{Multiplicative scaling factor.}

\item{width, height}{Plot size in units expressed by the \code{units} argument.
If not supplied, uses the size of the current graphics device.}

\item{units}{One of the following units in which the \code{width} and \code{height}
arguments are expressed: \code{"in"}, \code{"cm"}, \code{"mm"} or \code{"px"}.}

\item{dpi}{Plot resolution. Also accepts a string input: "retina" (320),
"print" (300), or "screen" (72). Only applies when converting pixel units,
as is typical for raster output types.}

\item{limitsize}{When \code{TRUE} (the default), \code{ggsave()} will not
save images larger than 50x50 inches, to prevent the common error of
specifying dimensions in pixels.}

\item{bg}{Background colour. If \code{NULL}, uses the \code{plot.background} fill value
from the plot theme.}

\item{create.dir}{Whether to create new directories if a non-existing
directory is specified in the \code{filename} or \code{path} (\code{TRUE}) or return an
error (\code{FALSE}, default). If \code{FALSE} and run in an interactive session,
a prompt will appear asking to create a new directory when necessary.}

\item{...}{Other arguments passed on to the graphics device function,
as specified by \code{device}.}
}
\value{
The function is called for its side effects: it saves the plot to a
file and returns the file path invisibly.
}
\description{
Saves a ggplot object just like \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}}. If the plot
has a \code{\link[=canvas]{canvas()}} specified, these canvas parameters are used.
User-specified parameters will override the canvas defaults.
}
\examples{
library(ggplot2)
p <-
  ggplot(mtcars, aes(wt, mpg)) +
  geom_point() +
  ggtitle("My awesome plot") +
  canvas(8, 6)

temp_file <- tempfile(fileext = ".png")
save_ggplot(p, temp_file)

}
