% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/team.R, R/team_invite.R, R/team_members.R,
%   R/team_pending.R, R/team_remove.R, R/team_repos.R
\name{team_members}
\alias{team_members}
\alias{team_invite}
\alias{team_pending}
\alias{team_remove}
\alias{team_repos}
\title{Tools for inviting, removing, and managing members of an organization team}
\usage{
team_invite(org, user, team, team_type = c("name", "slug"))

team_members(org, team = org_teams(org), team_type = c("name", "slug"))

team_pending(org, team = org_teams(org), team_type = c("name", "slug"))

team_remove(org, user, team, team_type = c("name", "slug"))

team_repos(org, team = org_teams(org), team_type = c("name", "slug"))
}
\arguments{
\item{org}{Character. Name of the GitHub organization.}

\item{user}{Character. One or more GitHub users to invite.}

\item{team}{Character. Name of teams.}

\item{team_type}{Character. Either "slug" if the team names are slugs or "name" if full team names are provided.}
}
\value{
\code{team_members()}, \code{team_pending()}, and \code{team_repos()} all return a tibble.

\code{team_invite()} and \code{team_remove()} invisibly return a list containing the results
of the relevant GitHub API calls.
}
\description{
\itemize{
\item \code{team_invite()} - add members to team(s).
\item \code{team_remove()} - remove members from team(s).
\item \code{team_members()} - returns a tibble of team members.
\item \code{team_pending()} - returns a tibble of pending team members.
\item \code{team_repos()} - returns a tibble of teams and their repos.
}
}
\examples{
\dontrun{
team_create("ghclass-test",c("hw1-team01","hw1-team02"))

team_invite("ghclass-test", user = "rundel", team = c("hw1-team01", "hw1-team02", "missing_team"))

team_remove("ghclass-test", user = "rundel", team = c("hw1-team01", "missing_team"))

team_members("ghclass-test", org_teams("ghclass-test", "hw1-"))

team_pending("ghclass-test", org_teams("ghclass-test", "hw1-"))

# Add team repo
repo_create("ghclass-test", name = "hw1-team02")
repo_add_team("ghclass-test/hw1-team02", team = "hw1-team02")

team_repos("ghclass-test", org_teams("ghclass-test", "hw1-"))


# Cleanup
repo_delete("ghclass-test/hw1-team02", prompt = FALSE)
team_delete("ghclass-test", org_teams("ghclass-test", "hw1-"), prompt = FALSE)
}

}
