% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GGM_generator.R
\name{ggm.generator}
\alias{ggm.generator}
\title{Simulate Data from Gaussian Graphical Model}
\usage{
ggm.generator(n, Omega)
}
\arguments{
\item{n}{The number of samples required.}

\item{Omega}{The inverse covariance matrix of the specified Gaussian graphical model.}
}
\value{
A numeric matrix with \code{n} rows and \code{p} variables where \code{p} corresponds to the dimension of \code{Omega}.
}
\description{
Produce one or more samples from the specified Gaussian graphical model.
}
\note{
\code{Omega} should be positive definite.
}
\examples{
library(gif)

set.seed(1)
n <- 200
p <- 100
Omega <- diag(1, p, p)
for(i in 1:(p - 1)) {
  Omega[i, i + 1] <- 0.5
  Omega[i + 1, i] <- 0.5
}
x <- ggm.generator(n, Omega)
}
