% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GGM.R
\name{sgt}
\alias{sgt}
\title{Soft Graphical Thresholding Algorithm}
\usage{
sgt(x, lambda, size = NULL)
}
\arguments{
\item{x}{There are 2 options: (1) \code{x} is an \eqn{n} by \eqn{p} data matrix; (2) a \eqn{p} by \eqn{p} sample covariance matrix. The program automatically identifies the input matrix by checking the symmetry. (\eqn{n} is the sample size and \eqn{p} is the dimension.)}

\item{lambda}{The regularization parameter for graphical lasso.}

\item{size}{A non-negative integer for determining the model size, i.e., the number of non-zero off-diagonal entries in the upper-triangular precision matrix,
which is also the number of edges in the graph. \code{size} must range from 0 to \eqn{(p^2 - p) / 2}.}
}
\value{
A list with following components:
\item{\code{Omega}}{Estimated inverse covariance matrix.}
\item{\code{active.entry}}{The position of the non-zero entries of \code{Omega}.}
\item{\code{is.acyclic}}{The boolean flag of whether the detected graph structure is acyclic or not.}
}
\description{
Estimates a sparse inverse covariance matrix using the closed form solution of graphical lasso under acyclic graph structure.
}
\details{
Soft Graphical Thresholding (SGT) algorithm proceeds by thresholding the sample covariance matrix and
estimating the inverse covariance matrix with a closed-form formula.
If the graph structure detected by the thresholding procedure is acyclic,
then the estimation is equivalent to the solution of graphical lasso.
}
\note{
Either \code{lambda} or \code{size} should specified when function \code{sgt} is called.
If both arguments are given, only \code{lambda} would be considered.
}
\examples{
library(gif)

data("ar1")
res <- sgt(ar1[["x"]], lambda = 0.01)
}
\references{
Fattahi, Salar, and Somayeh Sojoudi. Graphical Lasso and Thresholding: Equivalence and Closed-form Solutions. Journal of Machine Learning Research 20.10 (2019): 1-44. doi: 10.5555/3322706.3322716
}
