% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco-cache.R
\name{gisco_clear_cache}
\alias{gisco_clear_cache}
\title{Clear your \CRANpkg{giscoR} cache dir}
\usage{
gisco_clear_cache(config = FALSE, cached_data = TRUE, verbose = FALSE)
}
\arguments{
\item{config}{if \code{TRUE}, will delete the configuration folder of
\CRANpkg{giscoR}.}

\item{cached_data}{If this is set to \code{TRUE}, it will delete your
\code{cache_dir} and all its content.}

\item{verbose}{logical. If \code{TRUE} displays informational messages.}
}
\value{
Invisible. This function is called for its side effects.
}
\description{
\strong{Use this function with caution}. This function would clear your cached
data and configuration, specifically:
\itemize{
\item Deletes the \CRANpkg{giscoR} config directory
(\code{tools::R_user_dir("giscoR", "config")}).
\item Deletes the \code{cache_dir} directory.
\item Deletes the values on stored on \code{Sys.getenv("GISCO_CACHE_DIR")}.
}
}
\details{
This is an overkill function that is intended to reset your status
as it you would never have installed and/or used \CRANpkg{giscoR}.
}
\examples{

# Don't run this! It would modify your current state
\dontrun{
my_cache <- gisco_detect_cache_dir()

# Set an example cache
ex <- file.path(tempdir(), "example", "cache")
gisco_set_cache_dir(ex, verbose = FALSE)

# Restore initial cache
gisco_clear_cache(verbose = TRUE)

gisco_set_cache_dir(my_cache)
identical(my_cache, gisco_detect_cache_dir())
}
}
\seealso{
\code{\link[tools:userdir]{tools::R_user_dir()}}

Other cache utilities: 
\code{\link{gisco_set_cache_dir}()}
}
\concept{cache utilities}
