% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-issues.R
\name{get_issues}
\alias{get_issues}
\title{Returns open issues from an specific repository}
\usage{
get_issues(base_url, api_key, owner, repo, full_info = FALSE)
}
\arguments{
\item{base_url}{The base URL for your gitea server (no trailing '/')}

\item{api_key}{The user's API token key for the gitea service}

\item{owner}{The owner of the repository}

\item{repo}{The name of the repository}

\item{full_info}{TRUE or FALSE value. If FALSE this will select specific
columns from the issues data}
}
\description{
Returns open issues in an specific repository
}
\examples{
\dontrun{
get_issues(base_url = "https://example.gitea.service.com",
           api_key = "ccaf5c9a22e854856d0c5b1b96c81e851bafb288",
           owner = "company",
           repo = "test_repo",
           full_info = FALSE)
}
}
