% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect.R
\name{gl_connection}
\alias{gl_connection}
\alias{gl_project_connection}
\title{Connect to a specific GitLab instance API}
\usage{
gl_connection(
  gitlab_url,
  private_token,
  api_version = 4,
  api_location = paste0("/api/v", api_version, "/")
)

gl_project_connection(
  gitlab_url,
  project,
  private_token,
  api_version = 4,
  api_location = paste0("/api/v", api_version, "/")
)
}
\arguments{
\item{gitlab_url}{URL to the GitLab instance
(e.g. \verb{https://gitlab.myserver.com})}

\item{private_token}{private_token with which to identify.
You can generate one in the web interface under
\verb{GITLABINSTANCEURL/-/profile/personal_access_tokens.html} when logged on.}

\item{api_version}{Currently "4" for the latest GitLab API version.
See Details section on API versions.}

\item{api_location}{location of the GitLab API under the \code{gitlab_url},
usually and by default "/api/<<api_version>>/"}

\item{project}{id (preferred way) or name of the project.
Not repository name.}
}
\value{
A function to access a specific GitLab API
as a specific user, see details
}
\description{
Creates a function that can be used to issue requests to the specified
GitLab API instance with the specified user private token and (for \code{gl_project_connection})
only to a specified project.
}
\details{
The returned function should serve as the primary way to access the GitLab
API in the following. It can take vector/character arguments in the same way
as the function \code{\link[=gitlab]{gitlab()}} does, as well as the convenience functions
provided by this package or written by the user. If it is passed such that
function it calls it with the arguments provided in \code{...} and the GitLab
URL, api location and private_token provided when creating it via \code{gl_connection}.

Note: currently GitLab API v4 is supported. GitLab API v3 is no longer supported, but
you can give it a try.
}
\section{API versions}{

"v4" is the standard API since GitLab version 9.0
and only this version is officially supported by
'gitlabr' since version 1.1.6. "v3" as a parameter value
is not removed, since for many instances, 'gitlabr'
code will still work if you try.
}

\examples{
\dontrun{
# Set the connection for the session
set_gitlab_connection("https://gitlab.com", private_token = Sys.getenv("GITLAB_COM_TOKEN"))
# Get list of projects
gl_list_projects(max_page = 1)
# Unset the connection for the session
unset_gitlab_connection()

# Set connection for a specific project
my_project <- gl_project_connection(
  gitlab_url = "https://gitlab.com",
  project = 1234,
  private_token = Sys.getenv("GITLAB_COM_TOKEN")
)
# List files of a project
my_project_list_files <- my_project(gl_list_files, max_page = 1)
}

}
