% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci.R
\name{use_gitlab_ci}
\alias{use_gitlab_ci}
\title{Add .gitlab-ci.yml file in your current project from template}
\usage{
use_gitlab_ci(
  image = "rocker/verse:latest",
  path = ".gitlab-ci.yml",
  overwrite = TRUE,
  add_to_Rbuildignore = TRUE,
  type = "check-coverage-pkgdown",
  upgrade = TRUE
)
}
\arguments{
\item{image}{Docker image to use in GitLab ci. If NULL, not specified!}

\item{path}{destination path for writing GitLab CI yml file}

\item{overwrite}{whether to overwrite existing GitLab CI yml file}

\item{add_to_Rbuildignore}{add CI yml file and cache path used inside the
CI workflow to .Rbuildignore?}

\item{type}{type of the CI template to use}

\item{upgrade}{whether to upgrade the R packages to the latest version
during the CI. Default to TRUE.}
}
\value{
Used for side effects.
Creates a .gitlab-ci.yml file in your directory.
}
\description{
Add .gitlab-ci.yml file in your current project from template
}
\details{
Types available are:
\itemize{
\item "check-coverage-pkgdown": Check package along with
Code coverage with 'covr' and 'pkgdown' site on GitLab Pages
\item "check-coverage-pkgdown-renv": Check package built in a fixed 'renv' state
along with Code coverage with 'covr' and 'pkgdown' site on GitLab Pages.
\item "bookdown": Build 'bookdown' HTML and PDF site on GitLab Pages
\item "bookdown-production": Build 'bookdown' HTML and PDF site on GitLab Pages.
Where there will be a version of the book for each branch deployed.
See \url{https://github.com/statnmap/GitLab-Pages-Deploy} for setup details.
}
}
\examples{
# Create in another directory
use_gitlab_ci(
  image = "rocker/verse:latest",
  path = tempfile(fileext = ".yml")
)
\dontrun{
# Create in your current project with template for packages checking
use_gitlab_ci(image = "rocker/verse:latest", type = "check-coverage-pkgdown")
}
}
