% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmnetSE.R
\name{plot.glmnetSE}
\alias{plot.glmnetSE}
\title{Plot ROC Curve of a fitted glmnetSE Model on Test Data}
\usage{
\method{plot}{glmnetSE}(x, ...)
}
\arguments{
\item{x}{A model of the class \code{glmnetSE} of family \code{binomial} and performance metric \code{auc} for which the ROC curve should be plotted.}

\item{...}{Additional arguments affecting the plot produced.}
}
\value{
The ROC curve of a \code{glmnetSE} object.
}
\description{
Plot the ROC curve of a fitted  model \code{\link{glmnetSE}} (family \code{binomial} and performance metric \code{auc}) on supplied test data.
}
\examples{
\donttest{
# Generate dichotom variable

swiss$Fertility <- ifelse(swiss$Fertility >= median(swiss$Fertility), 1, 0)

# Generate a train and test set
set.seed(1234)
train_sample <- sample(nrow(swiss), 0.8*nrow(swiss))

swiss.train <- swiss[train_sample, ]
swiss.test  <- swiss[-train_sample, ]


# Estimate model

glmnetSE.model <- glmnetSE(data=swiss.train, cf.no.shrnkg = c("Education"),
alpha=seq(0.1,0.9,0.1), method = "10CVoneSE", test = swiss.test, seed = 123,
family = "binomial", perf.metric = "auc", ncore = 2)


# Plot ROC curve of the fitted model on swiss.test data

plot(glmnetSE.model)
}
}
\keyword{ROC}
\keyword{glmnetSE}
\keyword{plot}
