% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1-construct-dynamic-.R
\name{Dynamic}
\alias{Dynamic}
\title{Create \code{Dynamic} Object}
\usage{
Dynamic(marking, i, to = NULL, velocity = NULL, above = NULL)
}
\arguments{
\item{marking}{A single character, which represents the dynamic symbol on
the score. If \code{marking} is on the list in the \emph{Details} section, and
\code{velocity} is not specified, the corresponding velocity on the list will
be used. Otherwise, \code{velocity} must be specified, or the \code{Dynamic} will
have no sound effect.}

\item{i}{A single positive integer, which represents the position
of the \code{Dynamic} object in a musical line.}

\item{to}{Optional. A single character or a single positive integer,
which indicates the musical line where to add the \code{Dynamic}.}

\item{velocity}{Optional. A single integer between \code{0} and \code{127},
which indicates the loudness of the \code{Dynamic}.}

\item{above}{Optional. A single logical, which indicates whether the
dynamic symbol should appear above or below the staff.}
}
\value{
A list of class \code{Dynamic}.
}
\description{
Create a \code{Dynamic} object to represent a dynamic marking.
}
\details{
Common used dynamic markings and their velocities in MuseScore:
\itemize{
\item pppppp: 1
\item ppppp: 5
\item pppp: 10
\item ppp: 16
\item pp: 33
\item p: 49
\item mp: 64
\item mf: 80
\item f: 96
\item ff: 112
\item fff: 126
\item ffff: 127
\item fffff: 127
\item ffffff: 127
\item fp: 96
\item pf: 49
\item sf: 112
\item sfz: 112
\item sff: 126
\item sffz: 126
\item sfp: 112
\item sfpp: 112
\item rfz: 112
\item rf: 112
\item fz: 112
\item m: 96
\item r: 112
\item s: 112
\item z: 80
\item n: 49
}
}
\examples{
# Create a `Dynamic`
f <- Dynamic("f", 1)
f

# Add it to a `Music`
music <- Music() + Meter(4, 4) + Line(c("C4", "D4")) + f
music

# Generate the music score
if (interactive()) {
  show(music)
}
}
\seealso{
\code{\link[=+.Music]{+.Music()}} for adding an \code{Dynamic} to a \code{Music} object.
}
