% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1-construct-slur.R
\name{Slur}
\alias{Slur}
\title{Create \code{Slur} Object}
\usage{
Slur(i, j, to = NULL, to_j = NULL, above = NULL)
}
\arguments{
\item{i, j}{A single positive integer. They indicate the start
and end positions of the slur.}

\item{to, to_j}{Optional. A single character or a single positive integer,
which indicates the musical line where to add the slur. Specify \code{to_j}
if the start and end positions are in different musical lines.}

\item{above}{Optional. A single logical, which indicates whether the
slur should appear above or below the staff. By default, the position
is decided by MuseScore.}
}
\value{
A list of class \code{Slur}.
}
\description{
Create a \code{Slur} object to represent a slur.
}
\examples{
# Create a slur
slur <- Slur(1, 3)
slur

# Add it to a `Music`
music <- Music() + Meter(4, 4) + Line(c("C4", "D4", "E4")) + slur
music

# Generate the music score
if (interactive()) {
  show(music)
}
}
\seealso{
\code{\link[=+.Music]{+.Music()}} for adding a slur to a \code{Music} object.
}
