% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1-construct-tremolo.R
\name{Tremolo}
\alias{Tremolo}
\title{Create \code{Tremolo} Object}
\usage{
Tremolo(number, i, to = NULL, between = NULL)
}
\arguments{
\item{number}{A single integer which can be \code{1}, \code{2}, \code{3}, and \code{4}.
It indicates the speed of the tremolo.}

\item{i}{A single positive integer, which represents the position
of the tremolo in a musical line.}

\item{to}{Optional. A single character or a single positive integer,
which indicates the musical line where to add the tremolo.}

\item{between}{Optional. A single logical which indicates if the
tremolo is between notes.}
}
\value{
A list of class \code{Tremolo}.
}
\description{
Create a \code{Tremolo} object to represent a tremolo.
}
\examples{
# Create a tremolo
tremolo <- Tremolo(3, 1, between = TRUE)
tremolo

# Add it to a `Music`
music <- Music() + Meter(4, 4) + Line(c("C4", "D4", "E4", "F4")) + tremolo
music

# Generate the music score
if (interactive()) {
  show(music)
}
}
\seealso{
\code{\link[=+.Music]{+.Music()}} for adding a tremolo to a \code{Music} object.
}
