% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traffic_families.R
\name{trafficfam3}
\alias{trafficfam3}
\title{Draft of family for traffic example}
\usage{
trafficfam3(...)
}
\arguments{
\item{...}{Not used.}
}
\value{
A bamlss family object.
}
\description{
Fix four distributional assumptions and supply derivatives. Use gamma for
speed data. Use negative binomial for count data.
}
\examples{
# Construct data
set.seed(123)
# Number of subjects
n <- 10

# Number of observations
ni <- 3

# Covariate vector
x <- rep(rnorm(n), each = ni)
t <- rep(c(0, 0.5, 1), times = n)

# Additive predictor
eta_1 <- eta_2 <- eta_3 <- eta_4 <- t + 0.5*x

# Outcomes
y1 <- rnbinom(n*ni, exp(eta_1), 0.3)
y2 <- rnbinom(n*ni, exp(eta_2), 0.4)
y3 <- rgamma(n*ni, shape = 0.3, scale = exp(eta_3) / 0.3)
y4 <- rgamma(n*ni, shape = 0.4, scale = exp(eta_4) / 0.4)

# Data format
dat <- data.frame(
   id = factor(rep(seq_len(n), each = ni)),
   y = c(y1, y2, y3, y4),
   dim = factor(rep(c(1:4), each = n*ni)),
   t = t,
   x = x,
   fpc = 1
)

# Specify formula
f <- list(
  gm(y, dim) ~ t + x,
  sigma1 ~ 1,
  mu2 ~ t + x,
  sigma2 ~ 1,
  mu3 ~ t + x,
  sigma3 ~ 1,
  mu4 ~ t + x,
  sigma4 ~ 1,
  Lambda ~ -1 + s(id, by = fpc, bs = "re")
)

# Model
b <- bamlss(f, family = trafficfam3, n.iter = 20, burnin = 10,
            data = dat)
}
