% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glogitform.R
\name{gFormula}
\alias{gFormula}
\alias{is.gFormula}
\alias{model.frame.gFormula}
\alias{model.matrix.gFormula}
\title{Model Formula for Multinomial Logit Models}
\usage{
gFormula(object)

is.gFormula(object)

\method{model.frame}{gFormula}(formula, data, ..., lhs = NULL, rhs = NULL)

\method{model.matrix}{gFormula}(object, data, rhs = NULL, Q = NULL, ...)
}
\arguments{
\item{object}{a formula for the \code{gFormula} function, for the model.matrix method, a \code{gFormula} object,}

\item{formula}{a \code{gFormula} object,}

\item{data}{a \code{data.frame},}

\item{...}{further arguments.}

\item{lhs}{see \code{\link[Formula]{Formula}},}

\item{rhs}{see \code{\link[Formula]{Formula}},}

\item{Q}{number of classes for the latent class model,}
}
\description{
Four kind of variables are used in multinomial choice models with individual heterogeneity: alternative
specific and individual specific variables; variables for the mean of the random parameters (deterministic taste variations), and variables
for the scale function. \code{gFormula} deals with this type of models using suitable methods to extract
the elements of the model.
}
