% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/publish_data.R
\name{publish_data}
\alias{publish_data}
\title{Publish data in a repository}
\usage{
publish_data(
  input,
  name = NULL,
  target = Sys.getenv("PUBLISH_DATA_TARGET", unset = "."),
  ...
)
}
\arguments{
\item{input}{a vector of files to be downloaded or a cfg list with settings to be used (e.g. containing
cfg$input, cfg$repositories). Settings in the config list will be overwritten by other arguments of
this function if they are not set to NULL}

\item{name}{name of the data to be published (will be used in as file name). If no name is given (default) source
files will be published as is (separate tgz files with original name).}

\item{target}{target the data should be published in (format user@server:/folder/path) If a target vector, or targets
separated by "|" are provided the user will be asked interactively where the file should be written to.
By default it will look for target information in the environment variable PUBLISH_DATA_TARGET}

\item{...}{further options provided to \code{\link{download_unpack}}}
}
\description{
Downloads a list of tgz files from a list of repos, merge them and publish it on another server
}
\seealso{
\code{\link{download_unpack}},\code{\link{tardir}}
}
\author{
Jan Philipp Dietrich
}
