% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solveGP.R
\name{solveGP}
\alias{solveGP}
\title{Solves a weighted Linear Goal Programming problem}
\usage{
solveGP(A, b, w, varType, silent = FALSE)
}
\arguments{
\item{A}{Numeric matrix of coefficients of the goals (left-hand-side).}

\item{b}{Numerical vector. Right hand-side of the goals.}

\item{w}{Numerical matrix of the weights of the constrains. As many rows
as goals, and two columns (positive and negative deviations).}

\item{varType}{Character vector. Type of each variable ("i", "c" or "b" for
integer, continuous or binary, respectively). Must have as
many elements as columns in \code{A}.}

\item{silent}{Logical. TRUE to prevent the function writing anything
to the console (or the default output). Default is FALSE.}
}
\value{
An lp object, generated by the lpSolve package, which in turn calls
        the lp_solve C package.
}
\description{
Does not perform any check. It receives set of matrices and vectors
describing the original problem, and expands them adding the
corresponding deviations. It omits deviations with weight equal to NA.
}
