% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_postestimate.R
\name{logLik.result.goldfish}
\alias{logLik.result.goldfish}
\title{Extract log-likelihood from a fitted model object}
\usage{
\method{logLik}{result.goldfish}(object, ..., avgPerEvent = FALSE)
}
\arguments{
\item{object}{an object of class \code{result.goldfish} output from an
\code{\link{estimate}} call with a fitted model.}

\item{...}{additional arguments to be passed.}

\item{avgPerEvent}{a logical value indicating whether the average
likelihood per event should be calculated.}
}
\value{
Returns an object of class \code{logLik} when \code{avgPerEvent = FALSE}.
This is a number with the extracted log-likelihood from the fitted model,
and with the following attributes:
\item{df}{degrees of freedom with the number of estimated parameters in
the model}
\item{nobs}{the number of observations used in estimation.
In general, it corresponds to the number of dependent events used in
estimation. For a \code{subModel = "rate"} or \code{model = "REM"} with intercept,
it corresponds to the number of dependent events plus right-censored
events due to exogenous or endogenous changes.}

When \code{avgPerEvent = TRUE}, the function returns a number with the average
log-likelihood per event. The total number of events depends on the presence
of right-censored events in a similar way that the attribute \code{nobs}
is computed when \code{avgPerEvent = FALSE}.
}
\description{
This function extract the log-likelihood from the output of a
\code{estimate} call.
The extracted log-likelihood correspond to the value in the last
iteration of the \code{estimate} call, users should check convergence of
the Gauss/Fisher scoring method before using the log-likelihood statistic
to compare models.
}
\details{
Users might use \code{\link[stats:AIC]{stats::AIC()}} and \code{\link[stats:AIC]{stats::BIC()}} to compute the Information
Criteria from one or several fitted model objects.
An information criterion could be used to compare models
with respect to their predictive power.

Alternatively, \code{\link[lmtest:lrtest]{lmtest::lrtest()}} can be used to compare models via
asymptotic likelihood ratio tests. The test is designed to compare nested
models. i.e., models where the model specification of one contains a subset
of the predictor variables that define the other.
}
