% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_trials.R
\name{sim_trials}
\alias{sim_trials}
\title{Simulate one or more clinical trials subject to known design
parameters and treatment effect}
\usage{
sim_trials(
  hazard_treatment,
  hazard_control = NULL,
  cutpoints = 0,
  N_total,
  lambda = 0.3,
  lambda_time = 0,
  interim_look = NULL,
  end_of_study,
  prior = c(0.1, 0.1),
  block = 2,
  rand_ratio = c(1, 1),
  prop_loss = 0,
  alternative = "two.sided",
  h0 = 0,
  Fn = 0.1,
  Sn = 0.9,
  prob_ha = 0.95,
  N_impute = 10,
  N_mcmc = 10,
  N_trials = 10,
  method = "logrank",
  imputed_final = FALSE,
  ncores = 1L
)
}
\arguments{
\item{hazard_treatment}{vector. Constant hazard rates under the treatment
arm.}

\item{hazard_control}{vector. Constant hazard rates under the control arm.}

\item{cutpoints}{vector. Times at which the baseline hazard changes. Default
is \code{cutpoints = 0}, which corresponds to a simple (non-piecewise)
exponential model.}

\item{N_total}{integer. Maximum sample size allowable}

\item{lambda}{vector. Enrollment rates across simulated enrollment times. See
\code{\link{enrollment}} for more details.}

\item{lambda_time}{vector. Enrollment time(s) at which the enrollment rates
change. Must be same length as lambda. See \code{\link{enrollment}} for
more details.}

\item{interim_look}{vector. Sample size for each interim look. Note: the
maximum sample size should not be included.}

\item{end_of_study}{scalar. Length of the study; i.e. time at which endpoint
will be evaluated.}

\item{prior}{vector. The prior distributions for the piecewise hazard rate
parameters are each \eqn{Gamma(a_0, b_0)}, with specified (known)
hyper-parameters \eqn{a_0} and \eqn{b_0}. The default non-informative prior
distribution used is Gamma(0.1, 0.1), which is specified by setting
\code{prior = c(0.1, 0.1)}.}

\item{block}{scalar. Block size for generating the randomization schedule.}

\item{rand_ratio}{vector. Randomization allocation for the ratio of control
to treatment. Integer values mapping the size of the block. See
\code{\link{randomization}} for more details.}

\item{prop_loss}{scalar. Overall proportion of subjects lost to follow-up.
Defaults to zero.}

\item{alternative}{character. The string specifying the alternative
hypothesis, must be one of \code{"greater"} (default), \code{"less"} or
\code{"two.sided"}.}

\item{h0}{scalar. Null hypothesis value of \eqn{p_\textrm{treatment} -
  p_\textrm{control}} when \code{method = "bayes"}. Default is \code{h0 = 0}.
The argument is ignored when \code{method = "logrank"} or \code{= "cox"};
in those cases the usual test of non-equal hazards is assumed.}

\item{Fn}{vector of \code{[0, 1]} values. Each element is the probability
threshold to stop at the \eqn{i}-th look early for futility. If there are
no interim looks (i.e. \code{interim_look = NULL}), then \code{Fn} is not
used in the simulations or analysis. The length of \code{Fn} should be the
same as \code{interim_look}, else the values are recycled.}

\item{Sn}{vector of \code{[0, 1]} values. Each element is the probability
threshold to stop at the \eqn{i}-th look early for expected success. If
there are no interim looks (i.e. \code{interim_look = NULL}), then
\code{Sn} is not used in the simulations or analysis. The length of
\code{Sn} should be the same as \code{interim_look}, else the values are
recycled.}

\item{prob_ha}{scalar \code{[0, 1]}. Probability threshold of alternative
hypothesis.}

\item{N_impute}{integer. Number of imputations for Monte Carlo simulation of
missing data.}

\item{N_mcmc}{integer. Number of samples to draw from the posterior
distribution when using a Bayesian test (\code{method = "bayes"}).}

\item{N_trials}{integer. Number of trials to simulate.}

\item{method}{character. For an imputed data set (or the final data set after
follow-up is complete), whether the analysis should be a log-rank
(\code{method = "logrank"}) test, Cox proportional hazards regression model
Wald test (\code{method = "cox"}), a fully-Bayesian analysis (\code{method
  = "bayes"}), or a chi-square test (\code{method = "chisq"}). See Details
section.}

\item{imputed_final}{logical. Should the final analysis (after all subjects
have been followed-up to the study end) be based on imputed outcomes for
subjects who were LTFU (i.e. right-censored with time
\code{<end_of_study})? Default is \code{TRUE}. Setting to \code{FALSE}
means that the final analysis would incorporate right-censoring.}

\item{ncores}{integer. Number of cores to use for parallel processing.}
}
\value{
Data frame with 1 row per simulated trial and columns for key summary
statistics. See \code{\link{survival_adapt}} for details of what is
returned in each row.
}
\description{
Simulate multiple clinical trials with fixed input parameters,
and tidily extract the relevant data to generate operating characteristics.
}
\details{
This is basically a wrapper function for
\code{\link{survival_adapt}}, whereby we repeatedly run the function for a
independent number of trials (all with the same input design parameters and
treatment effect).

To use will multiple cores (where available), the argument \code{ncores}
can be increased from the default of 1. Note: on Windows machines, it is
not possible to use the \code{\link[parallel]{mclapply}} function with
\code{ncores} \eqn{>1}.
}
\examples{
hc <- prop_to_haz(c(0.20, 0.30), c(0, 12), 36)
ht <- prop_to_haz(c(0.05, 0.15), c(0, 12), 36)

out <- sim_trials(
  hazard_treatment = ht,
  hazard_control = hc,
  cutpoints = c(0, 12),
  N_total = 600,
  lambda = 20,
  lambda_time = 0,
  interim_look = c(400, 500),
  end_of_study = 36,
  prior = c(0.1, 0.1),
  block = 2,
  rand_ratio = c(1, 1),
  prop_loss = 0.30,
  alternative = "two.sided",
  h0 = 0,
  Fn = 0.05,
  Sn = 0.9,
  prob_ha = 0.975,
  N_impute = 5,
  N_mcmc = 5,
  method = "logrank",
  N_trials = 2,
  ncores = 1)
}
