
#' @title BP GO-terms as an Edgelist for Mouse
#'
#' @description A data set containing BP, MF and CC GO-terms as an edgelist for Mouse.
#'
#' @format A list containing 3 objects:
#' \describe{
#'   \item{BPlist}{BP GO-terms edgelist.}
#'   \item{MFlist}{MF GO-terms edgelist.}
#'   \item{CClist}{CC GO-terms edgelist.}
#' }
#' @source <https://www.nature.com/articles/s41598-020-73326-3>
"Mouse"

#' @title BP GO-terms as an Edgelist for Rat
#'
#' @description A data set containing BP, MF and CC GO-terms as an edgelist for Rat
#'
#' @format A list containing 3 objects:
#' \describe{
#'   \item{BPlist}{BP GO-terms edgelist.}
#'   \item{MFlist}{MF GO-terms edgelist.}
#'   \item{CClist}{CC GO-terms edgelist.}
#' }
#' @source <https://www.nature.com/articles/s41598-020-73326-3>
"Rat"


#' @title BP GO-terms reduced GO-DAG for Mouse
#'
#' @description A data set with list containing information about the reduced GO-BP dag for Mouse
#'
#' @format A list with 3 objects:
#' \describe{
#'   \item{v}{GO-terms in the respective nodes.}
#'   \item{dat.d}{Data frame object that shows how the respective nodes are connected.}
#'   \item{df}{Sketelon of the reduced GO-dags.}
#'
#' }
#' @source <https://www.nature.com/articles/s41598-020-73326-3>
"BPMouse"

#' @title BP GO-terms reduced GO-DAG for Rat
#'
#' @description A data set with list containing information about the reduced GO-BP dag for Rat.
#'
#' @format A list with 3 objects:
#' \describe{
#'   \item{v}{GO-terms in the respective nodes.}
#'   \item{dat.d}{Data frame object that shows how the respective nodes are connected.}
#'   \item{df}{Sketelon of the reduced GO-dags.}
#'
#' }
#' @source <https://www.nature.com/articles/s41598-020-73326-3>
"BPRat"

#' @title MF GO-terms reduced GO-DAG for Mouse
#'
#' @description A data set with list containing information about the reduced GO-BP DAG for Mouse.
#'
#' @format A list with 3 objects:
#' \describe{
#'   \item{v}{GO-terms in the respective nodes.}
#'   \item{dat.d}{Data frame object that shows how the respective nodes are connected.}
#'   \item{df}{Sketelon of the reduced GO-dags.}
#'
#' }
#' @source <https://www.nature.com/articles/s41598-020-73326-3>
"MFMouse"

#' @title CC GO-terms reduced GO-DAG for Mouse
#'
#' @description A data set with list containing information about the reduced GO-BP DAG for Mouse.
#'
#' @format A list with 3 objects:
#' \describe{
#'   \item{v}{GO-terms in the respective nodes.}
#'   \item{dat.d}{Data frame object that shows how the respective nodes are connected.}
#'   \item{df}{Sketelon of the reduced GO-dags.}
#'
#' }
#' @source <https://www.nature.com/articles/s41598-020-73326-3>
"CCMouse"


#' @title MF GO-terms reduced GO-DAG for Rat
#'
#' @description A data set with list containing information about the reduced GO-BP DAG for Rat
#'
#' @format A list with 3 objects:
#' \describe{
#'   \item{v}{GO-terms in the respective nodes.}
#'   \item{dat.d}{Data frame object that shows how the respective nodes are connected.}
#'   \item{df}{Sketelon of the reduced GO-dags.}
#'
#' }
#' @source <https://www.nature.com/articles/s41598-020-73326-3>
"MFRat"

#' @title CC GO-terms reduced GO-DAG for Rat
#'
#' @description A data set with list containing information about the reduced GO-BP DAG for Rat.
#'
#' @format A list with 3 objects:
#' \describe{
#'   \item{v}{GO-terms in the respective nodes.}
#'   \item{dat.d}{Data frame object that shows how the respective nodes are connected.}
#'   \item{df}{Sketelon of the reduced GO-dags.}
#'
#' }
#' @source <https://www.nature.com/articles/s41598-020-73326-3>
"CCRat"

#' @title All GO-terms for Mouse
#'
#' @description A data set with all the GO-terms for Mouse.
#'
#' @format A data frame with 337505 rows and 2 variables:
#' \describe{
#'   \item{entrezgene_id}{The entrezgene_id.}
#'   \item{go_id}{The respective GO-terms.}
#' }
#' @source <https://www.nature.com/articles/s41598-020-73326-3>
"MouseAll"

#' @title All GO-terms for Rat
#'
#' @description A data set with all the GO-terms for Rat.
#'
#' @format A data frame with 262619 rows and 2 variables:
#' \describe{
#'   \item{entrezgene_id}{The entrezgene_id.}
#'   \item{go_id}{The respective GO-terms.}
#' }
#' @source <https://www.nature.com/articles/s41598-020-73326-3>
"RatAll"

