% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/views.R
\name{ga_view_list}
\alias{ga_view_list}
\title{List View (Profile)}
\usage{
ga_view_list(accountId, webPropertyId)
}
\arguments{
\item{accountId}{Account Id}

\item{webPropertyId}{Web Property Id e.g. \code{UA-12345-1}}
}
\value{
A \code{data.frame} of meta-data for the views
}
\description{
This gets the meta data associated with the Google Analytics Views for a particular accountId and webPropertyId.
If you want all viewId information for all accounts you have access to, use \link{ga_account_list} instead.
}
\examples{

\dontrun{
library(googleAnalyticsR)
ga_auth()
views <- ga_view_list(1058095, "UA-1058095-1")
}
}
\seealso{
Other account structure functions: 
\code{\link{ga_account_list}()},
\code{\link{ga_accounts}()},
\code{\link{ga_view}()},
\code{\link{ga_webproperty}()},
\code{\link{ga_webproperty_list}()}
}
\concept{account structure functions}
