% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5-grafos-arbol.R
\encoding{UTF-8}
\name{dfs_tree}
\alias{dfs_tree}
\title{Depth-first search tree}
\usage{
dfs_tree(g, r)
}
\arguments{
\item{g}{Graph}

\item{r}{Root: Starting vertex growing the tree.}
}
\value{
A directed spanning subgraph of g containing the edges of
the DFS tree.
}
\description{
Computation of the depth-first tree search in an undirected graph.
}
\details{
Starting from a root vertex, the tree is grown by adding neighbors
of the last vertex added to the tree.  In this way, the tree
has many levels and few branches and leaves.  When the tree
cannot grow further, it backtracks to previously added
vertices with neighbors outside the tree, adding them until
none is left.
}
\examples{
library(igraph)
g <- make_graph("Frucht")
T <- dfs_tree(g, 5)  # Root at v = 5
z <- layout_with_gem(g)
plot(g, layout = z, main = "Depth-first search tree")
plot(T, layout = z, add = TRUE, edge.color = "cyan4", edge.width = 2)
plot(T, layout = layout_as_tree(T))

}
\seealso{
\code{\link[=bfs_tree]{bfs_tree()}} breadth-first search tree; \code{\link[igraph:bfs]{igraph::bfs()}}
and \code{\link[igraph:dfs]{igraph::dfs()}} in the igraph package.
}
\author{
Cesar Asensio
}
