% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gotop.R
\name{use_gotop}
\alias{use_gotop}
\title{Add scroll up icon}
\usage{
use_gotop(
  src = "fas fa-chevron-up",
  width = 45,
  opacity = 0.5,
  place = "right",
  color = "",
  appear = 200,
  scrolltime = 800,
  fadein = 500,
  fadeout = 500,
  marginX = 2,
  marginY = 2,
  container = "",
  zIndex = 9,
  use_cdn = TRUE
)
}
\arguments{
\item{src}{A string. The CSS classes used to display the gotop icon.}

\item{width}{An integer. The width of the gotop icon.}

\item{opacity}{decimal Sets the transparency level for the gotop icon, where 1 is not transparent at all, 0.5 is 50 percent see-through and 0 is completely transparent.}

\item{place}{A string. The location where the gotop icon will be shown. Valid values are 'right' or 'left'.}

\item{color}{A string. The color of the selected the gotop icon.}

\item{appear}{An integer. The amount of pixels the page must be scrolled down before the gotop icon is displayed.}

\item{scrolltime}{An integer. A number determining how long the animation will run when scrolling to the top of the page.}

\item{fadein}{An integer. A number determining how long the animation will run when fading in to opaque.}

\item{fadeout}{An integer. A number determining how long the animation will run when fading out to transparent.}

\item{marginX}{An integer. The percentage amount indicating how far away the gotop icon is from the bottom, left, or right, depending on the value of place.}

\item{marginY}{An integer. The percentage amount indicating how far away the gotop icon is from the top or bottom, depending on the value of place.}

\item{container}{A string. The HTML element to which the scroll function will be attached. If no value is given, then the scroll function will be attched to the window.}

\item{zIndex}{An integer. The z-index value.}

\item{use_cdn}{boolean. TRUE to use a Content Delivery Network (CDN), true by default, or false to use locally stored files.}
}
\value{
Javascript code initializing GoTop with dependencies
}
\description{
Add scroll up icon
}
\examples{
use_gotop()

}
