% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/service-anthropic.R
\name{create_completion_anthropic}
\alias{create_completion_anthropic}
\title{Generate text completions using Anthropic's API}
\usage{
create_completion_anthropic(
  prompt = list(list(role = "user", content = "Hello")),
  system = NULL,
  model = "claude-3-haiku-20240307",
  max_tokens = 1028,
  key = Sys.getenv("ANTHROPIC_API_KEY")
)
}
\arguments{
\item{prompt}{The prompt for generating completions}

\item{system}{A system messages to instruct the model. Defaults to NULL.}

\item{model}{The model to use for generating text. By default, the
function will try to use "claude-2.1".}

\item{max_tokens}{The maximum number of tokens to generate. Defaults to 256.}

\item{key}{The API key for accessing Anthropic's API. By default, the
function will try to use the \code{ANTHROPIC_API_KEY} environment variable.}
}
\value{
A list with the generated completions and other information returned
by the API.
}
\description{
Generate text completions using Anthropic's API
}
\examples{
\dontrun{
create_completion_anthropic(
  prompt = "\n\nHuman: Hello, world!\n\nAssistant:",
  model = "claude-3-haiku-20240307",
  max_tokens = 1028
)
}
}
