% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/service-huggingface.R
\name{create_completion_huggingface}
\alias{create_completion_huggingface}
\title{Generate text completions using HuggingFace's API}
\usage{
create_completion_huggingface(
  prompt,
  history = NULL,
  model = "tiiuae/falcon-7b-instruct",
  token = Sys.getenv("HF_API_KEY"),
  max_new_tokens = 250
)
}
\arguments{
\item{prompt}{The prompt for generating completions}

\item{history}{A list of the previous chat responses}

\item{model}{The model to use for generating text}

\item{token}{The API key for accessing HuggingFace's API. By default, the
function will try to use the \code{HF_API_KEY} environment variable.}

\item{max_new_tokens}{Maximum number of tokens to generate, defaults to 250}
}
\value{
A list with the generated completions and other information returned
by the API.
}
\description{
Generate text completions using HuggingFace's API
}
\examples{
\dontrun{
create_completion_huggingface(
  model = "gpt2",
  prompt = "Hello world!"
)
}
}
