% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oc_plan.R
\name{oc_plan}
\alias{oc_plan}
\title{Construction of  Operating Characteristic (OC) curve}
\usage{
oc_plan(c, r, t, distribution, K, m, sd)
}
\arguments{
\item{c}{acceptance number}

\item{r}{number of primary increments in a grab sample or grab sample size}

\item{t}{number of grab samples}

\item{distribution}{what suitable distribution we have used such as   \code{'Poisson gamma'} or \code{'Lognormal'} or \code{'Poisson lognormal'}}

\item{K}{dispersion parameter of the Poisson gamma distribution (default value 0.25)}

\item{m}{microbiological limit with default value zero, generally expressed as number of microorganisms in specific sample weight}

\item{sd}{standard deviation of the lognormal and Poisson-lognormal distributions on the log10 scale (default value 0.8)}
}
\value{
Operating Characteristic (OC) curve
}
\description{
\code{\link{oc_plan}} provides the Operating Characteristic (OC) curve for known microbiological distribution such as lognormal. The probability of acceptance is plotted against mean log10 concentration.
}
\details{
Based on the food safety literature, mean concentration is given by \eqn{\lambda = 10^{\mu+log(10)\sigma^2/2}}.
}
\examples{
  c <-  0
  r <-  25
  t <-  30
  distribution <- 'Poisson lognormal'
  oc_plan(c, r, t, distribution)
}
\seealso{
\link{prob_accept}
}
