% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prob_detect.R
\name{prob_detect}
\alias{prob_detect}
\title{Probability of detection under the grab sampling method}
\usage{
prob_detect(c, r, t, d, p, N, method)
}
\arguments{
\item{c}{acceptance number}

\item{r}{number of primary increments in a grab sample or grab sample size}

\item{t}{number of grab samples}

\item{d}{serial correlation of contamination between the primary increments}

\item{p}{limiting fraction or proportion of contaminated increments}

\item{N}{length of the production}

\item{method}{what sampling method we have applied such as \code{'systematic'} or \code{'random'} selection methods}
}
\value{
Probability of detection in all seleceted grab samples
}
\description{
This function gives the detection probability for  \code{t} grab samples and given acceptance number under systematic or random sampling methods. This function is also used to calculate the detection probability for primary increments selection by setting the number of primary increments as one.
}
\details{
The detection probability of entire selected grab samples is given by,
\deqn{P_D=1-[P(S_t=0)+P(S_t=1)+\cdots +P(S_t=c)]}
}
\examples{
  c <-  1
  r <-  25
  t <-  30
  d <-  0.99
  p <-  0.005
  N <-  1e9
  method <- 'systematic'
  prob_detect(c, r, t, d, p, N, method)
}
\seealso{
\link{prob_contaminant}
}
