% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.grapherator}
\alias{plot.grapherator}
\title{Visualize graph.}
\usage{
\method{plot}{grapherator}(x, y = NULL, show.cluster.centers = TRUE,
  highlight.clusters = FALSE, show.edges = TRUE,
  weight.plot.type = "histogram", ...)
}
\arguments{
\item{x}{[\code{grapherator}]\cr
Graph.}

\item{y}{Not used at the moment.}

\item{show.cluster.centers}{[\code{logical(1)}]\cr
Display cluster centers?
Default is \code{TRUE}. This option is ignored silently if the instance is not clustered.}

\item{highlight.clusters}{[\code{logical(1)}]\cr
Shall nodes be coloured by cluster membership?
Default is \code{FALSE}.}

\item{show.edges}{[\code{logical(1)}]\cr
Display edges? Keep in mind, that the number of edges is \eqn{O(n^2)}
where \eqn{n} is the number of nodes.
Default is \code{TRUE}.}

\item{weight.plot.type}{[\code{character(1)}]\cr
Type of visualization which should be used for weights in case \code{x} has only
as single weight attached to each edge. Either \dQuote{histogram} or \dQuote{ecdf}
(empirical distribution function) are possible choices.
Default is \code{histogram}.}

\item{...}{[any]\cr
Not used at the moment.}
}
\value{
[\code{list}] A list of \code{\link[ggplot2]{ggplot}} objects with components
\code{pl.weights} (scatterplot of edge weights) and eventually \code{pl.coords} (scatterplot of
nodes). The latter is \code{NULL}, if \code{graph} has no associated coordinates.
}
\description{
\code{plot.grapherator} generates a scatterplot of the nodes in the
Euclidean plane. Additionally, the edge weights are visualized. In case of one
weight per edge either a histogram or an empirical distribution function is drawn.
For graphs with two weights per edge a scatterplot is used.
}
\examples{
g = graph(0, 100)
g = addNodes(g, n = 25, generator = addNodesGrid)
g = addEdges(g, generator = addEdgesDelauney)
g = addWeights(g, generator = addWeightsDistance, method = "manhattan")
\dontrun{
pls = plot(g, weight.plot.type = "ecdf")
}

g = addWeights(g, generator = addWeightsRandom,
  method = rpois, lambda = 0.1)
\dontrun{
pls = plot(g, show.edges = FALSE)
}

g = graph(0, 100)
g = addNodes(g, n = 25, generator = addNodesGrid)
g = addNodes(g, n = 9, by.centers = TRUE, generator = addNodesGrid,
  lower = c(0, 0), upper = c(7, 7))
g = addEdges(g, generator = addEdgesDelauney)
g = addWeights(g, generator = addWeightsCorrelated, rho = -0.8)
\dontrun{
do.call(gridExtra::grid.arrange, plot(g, show.edges = FALSE))
do.call(gridExtra::grid.arrange, plot(g, show.edges = TRUE,
  show.cluster.centers = FALSE))
}
}
